
/* 
 * Author : Stephen Smalley (NAI Labs), <ssmalley@nai.com> 
 *
 * The policy compiler was originally written while I was employed by NSA,
 * but I have implemented a number of extensions and revisions since 
 * joining NAI Labs.
 */

/* FLASK */

%{
#include "y.tab.h"

unsigned int policydb_lineno = 1;

unsigned int policydb_errors = 0;
%}
%array
letter  [A-Za-z]
digit   [0-9]
%%
CLONE |
clone				{ return(CLONE); }
COMMON |
common				{ return(COMMON); }
CLASS |
class				{ return(CLASS); }
CONSTRAIN |
constrain			{ return(CONSTRAIN); }
INHERITS |
inherits			{ return(INHERITS); }
SID |
sid				{ return(SID); }
ROLE |
role				{ return(ROLE); }
ROLES |
roles				{ return(ROLES); }
TYPES |
types				{ return(TYPES); }
TYPE |
type				{ return(TYPE); }
ALIAS |
alias				{ return(ALIAS); }
TYPE_TRANSITION |
type_transition			{ return(TYPE_TRANSITION); }
TYPE_MEMBER |
type_member			{ return(TYPE_MEMBER); }
TYPE_CHANGE |
type_change			{ return(TYPE_CHANGE); }
ROLE_TRANSITION |
role_transition			{ return(ROLE_TRANSITION); }
SENSITIVITY |
sensitivity		{ return(SENSITIVITY); }
DOMINANCE |
dominance			{ return(DOMINANCE); }
CATEGORY |
category			{ return(CATEGORY); }
LEVEL |
level				{ return(LEVEL); }
RANGES |
ranges				{ return(RANGES); }
USER |
user				{ return(USER); }
NEVERALLOW |
neverallow		        { return(NEVERALLOW); }
ALLOW |
allow			        { return(ALLOW); }
AUDITALLOW |
auditallow		        { return(AUDITALLOW); }
AUDITDENY |
auditdeny		        { return(AUDITDENY); }
SOURCE |
source			        { return(SOURCE); }
TARGET |
target			        { return(TARGET); }
SAMEUSER |
sameuser			{ return(SAMEUSER);}
OR |
or     			        { return(OR);}
AND |
and				{ return(AND);}
NOT |
not				{ return(NOT);}
eq |
EQ				{ return(EQUALS);}
dom |
DOM				{ return(DOM);}
domby |
DOMBY				{ return(DOMBY);}
INCOMP |
incomp				{ return(INCOMP);}
r1 |
R1				{ return(R1); }
r2 |
R2				{ return(R2); }
u1 |
U1				{ return(U1); }
u2 |
U2				{ return(U2); }
t1 |
T1				{ return(T1); }
t2 |
T2				{ return(T2); }
"/"({letter}|{digit}|_|"/")*	{ return(PATH); }
{letter}({letter}|{digit}|_)*	{ return(IDENTIFIER); }
{digit}{digit}*                 { return(NUMBER); }
#[^\n]*                         { /* delete comments */ }
[ \t\f]+			{ /* delete whitespace */ }
\n				{ /* delete whitespace */ policydb_lineno++; }
"==" 				{ return(EQUALS); }
"!="				{ return (NOTEQUAL); }
"&&"				{ return (AND); }
"||"				{ return (OR); }
"!"				{ return (NOT); }
"," |
":" |
";" |
"(" | 
")" |
"{" | 
"}" |
"[" |
"-" |
"." |
"]" |
"~" |
"*"				{ return(yytext[0]); } 
%%
int yyerror(char *msg)
{
	fprintf(stderr, "\nerror in the statement ending on line %d (token '%s'): %s\n\n", policydb_lineno, yytext, msg);
	policydb_errors++;
	return -1;
}

int yywarn(char *msg)
{
	fprintf(stderr, "\nwarning about the statement ending on line %d (token '%s'): %s\n\n", policydb_lineno, yytext, msg);
	return 0;
}


