/* getsecsid.c
 *
 * returns the SID and security context in which the user is 
 * currently running
 */

#include <proc_secure.h>
#include <ss.h>
#include <stdlib.h>
#include <errno.h>

int main(int argc, char **argv, char **envp)
{
	int rc;
	security_id_t sid;
#define INITLEN 255
	char *scontext;
	int ctxtlen;

	if (argc != 1) {
		printf("usage:  %s\n", argv[0]);
		exit(1);
	}

	if ((rc = getsecsid()) < 0) {
		perror("getsecsid");
		exit(2);
	}
	sid = rc;
	printf("SID:  %d\n", sid);

	scontext = malloc(INITLEN);
	ctxtlen = INITLEN;
	if (!scontext) {
		perror("malloc");
		exit(2);
	}
	rc = security_sid_to_context(sid, scontext, &ctxtlen);
	if (rc && errno == ENOSPC) {
		scontext = realloc(scontext, ctxtlen);
		if (!scontext) {
			perror("realloc");
			exit(2);
		}
		rc = security_sid_to_context(sid, scontext, &ctxtlen);
	}

	if (rc) {
		perror("security_sid_to_context");
		exit(2);
	}

	printf("Context:  %s\n", scontext);

	exit(0);
}
