#include <fs_secure.h>
#include <ss.h>
#include <stdlib.h>

int main(int argc, char **argv)
{
	security_id_t sid[2];
	int rc, i;

	if (argc < 4) {
		printf("usage:  %s sid/context sid/context pathname...\n",
		       argv[0]);
		exit(1);
	}

	for (i = 0; i < 2; i++) {
		sid[i] = atoi(argv[i + 1]);
		if (!sid[i]) {
			rc = security_context_to_sid(argv[i + 1],
						     strlen(argv[i + 1]) +
						     1, &sid[i]);
			if (rc) {
				perror(argv[i + 1]);
				exit(1);
			}
		}
	}

	for (i = 3; i < argc; i++) {
		if (chsidfs(argv[i], sid[0], sid[1]) < 0) {
			perror(argv[i]);
			exit(2);
		}
	}

	exit(0);
}
