#include <fs_secure.h>
#include <ss.h>
#include <stdlib.h>

int main(int argc, char **argv)
{
	security_id_t sid;
	int rc, i;

	if (argc < 3) {
		printf("usage:  %s sid/context pathname...\n", argv[0]);
		exit(1);
	}

	sid = atoi(argv[1]);
	if (!sid) {
		rc = security_context_to_sid(argv[1], strlen(argv[1]) + 1,
					     &sid);
		if (rc) {
			perror(argv[1]);
			exit(1);
		}
	}

	for (i = 2; i < argc; i++) {
		if (chsid(argv[i], sid) < 0) {
			perror(argv[i]);
			exit(2);
		}
	}

	exit(0);
}
