#include <sys/socket.h>
#include <lsm.h>

int 
getsockname_secure(int s, struct sockaddr *addr, int *addrlen, 
		   security_id_t *sid)
{
	unsigned long args[4];

	args[0] = s;
	args[1] = (unsigned long)addr;
	args[2] = (unsigned long)addrlen;
	args[3] = (unsigned long)sid;

	return lsm(SELINUX_MAGIC, SELINUXCALL_GETSOCKNAME, args);
}
