#include <linux/flask/syscalls.h>
#include <proc_secure.h>
#include <lsm.h>

int execve_secure(const char *filename, 
		  char *const argv[],
		  char *const envp[],
		  security_id_t sid)
{
	unsigned long args[4];
	

	args[0] = (unsigned long)filename;
	args[1] = (unsigned long)argv;
	args[2] = (unsigned long)envp;
	args[3] = (unsigned long)sid;
	return lsm(SELINUX_MAGIC, SELINUXCALL_EXECVE, args);
}




