#define _LARGEFILE64_SOURCE 
#include <fs_secure.h>
#include <lsm.h>
#include <errno.h>
#include "kernel_stat64.h"
#include "xstat64_conv.h"
#include <flask_util.h>

int fstat64_secure(unsigned int fd,
		   struct stat64 *buf, 
		   security_id_t *out_sid)
{
	struct kernel_stat64 kbuf;
	unsigned long args[3];
	long err;

	if (is_flask_enabled()) {	
		args[0] = (unsigned long)fd;
		args[1] = (unsigned long)&kbuf;
		args[2] = (unsigned long)out_sid;
		err = lsm(SELINUX_MAGIC, SELINUXCALL_FSTAT64, args);
		if (err)
			return err;
		return xstat64_conv(_STAT_VER_LINUX, &kbuf, buf);
	} else {
		/* Compatibility for the modified utilities
		   until they are fixed. */
		*out_sid = SECINITSID_UNLABELED;
		return fstat64(fd, buf);
	}
}
