#ifndef _IPC_SECURE_H
#define _IPC_SECURE_H

#include <sys/types.h>
#include <unistd.h>
#include <linux/flask/flask.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>

extern int
msgget_secure (key_t key, int msgflag, security_id_t sid);

extern int
msgsid (int msqid, security_id_t *sid);

extern int
msgsnd_secure (int msqid, void *msgp, size_t msgsz, int msgflg,
	       security_id_t sid);

extern int
msgrcv_secure (int msqid, void *msgp, size_t msgsz, long msgtyp,
	       int msgflg, security_id_t *sidp);

extern int
semget_secure (key_t key, int nsems, int semflag, security_id_t sid);

extern int
semsid (int semid, security_id_t *sid);

extern int
shmget_secure (key_t key, int size, int flag, security_id_t sid);

extern int
shmsid (int shmid, security_id_t *sid);

#endif /* _IPC_SECURE_H */
