/* get_default_type.h - contains header information and function prototypes
 *                  for functions to get the default type for a role
 */

#ifndef _GET_DEFAULT_TYPE_H_
#define _GET_DEFAULT_TYPE_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define _DEFTYPE_PATH "/etc/security/default_type"

/* get_default_type - given role of length len, sets def_type to the
   default type to use for that role.  Returns 1 if the type was found
   and 0 otherwise
 */
int get_default_type (const char* role, const int len, char** type);

/* The following functions are support functions for get_default_type */
int find_default_type (FILE* fseccon, const char* role, const int len,
		       char** type);

#endif  /* ifndef _GET_DEFAULT_TYPE_H_ */
