
#include <errno.h>               /* for errno and ENOSYS */
#include <proc_secure.h>         /* for getsecsid() */

static inline int is_flask_enabled(void);

/* is_flask_enabled()
 *
 * This function is a predicate that returns 1 if the kernel has
 * the extra SELinux system calls, or 0 if it does not.
 */
static inline int is_flask_enabled( void ) 
{
	int ret;

	ret = getsecsid();
	if (ret <= 0)
		return 0; /* No SELinux */
	else
		return 1;
} 
