class TestMOTDUpdating(TestBase):
	"""
	MOTD updating is not supported by SELinux.
	"""
	class ErrorMOTDUpdating(ErrorBase):
		def __str__(self):
			return "Dynamic motd updating is enabled"
		def fixable(self):
			return False
		def fix(self):
			print "TODO: Edit /etc/default/rcS and set EDITMOTD=no"
			return False

	class ErrorDynamicMOTD(ErrorBase):
		def __str__(self):
			return "A dynamic MOTD is present in /var/run/motd."
		def fixable(self):
			return True
		def fix(self):
			import os
			return os.unlink("/var/run/motd")

	@staticmethod
	def test():
		import os, re
		r = re.compile(r'^\s*EDITMOTD=.*no')
		result = []

		if os.access("/etc/default/rcS", os.F_OK):
			editmotd = True
			f = open("/etc/default/rcS","r")
			for line in f.readlines():
				if r.match(line):
					editmotd = False
			f.close()
			if editmotd:
				result.append(TestMOTDUpdating.ErrorMOTDUpdating())
		else:
			raise "Couldn't access /etc/default/rcS, is this Debian?"

		if os.access("/var/run/motd", os.F_OK):
			result.append(TestMOTDUpdating.ErrorDynamicMOTD())
		return result
register_test(TestMOTDUpdating)
