#include <stdio.h>  
#include <string.h>
#include <stdlib.h>  
#include <sys/types.h>

#include "../include/os.h"

#ifdef __MSW__
# include <windows.h>
#else
# include <sys/time.h>
# include <unistd.h>
#endif

#include "gw.h"
#include "messages.h"
#include "sarreality.h"
#include "obj.h"
#include "mission.h"

#include "sar.h"


void SARSimEnd(sar_core_struct *core_ptr);


#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))


/*
 *	Procedure to end simulation, this function should be called as the
 *	procedure to tabulate the end of a mission or simulation and
 *	return to the menus.
 *
 *	The simulation type (campaign, mission, freeflight, etc) will
 *	be checked.
 */
void SARSimEnd(sar_core_struct *core_ptr)
{
        if(core_ptr == NULL)
            return;

	if(option.runtime_debug)
	    printf("SARSimEnd(): Ending simulation...\n");

        if(core_ptr->mission != NULL)
        { 
            sar_mission_struct *mission = core_ptr->mission;

            if(option.runtime_debug)
                printf("SARSimEnd(): Tabulating mission results...\n");

	    /* Check state of mission. */
            switch(mission->state)
            {
	      case MISSION_STATE_IN_PROGRESS:
		/* Mission was still in progress, aborted. */

		break;

	      case MISSION_STATE_FAILED:
		/* Mission failed. */

		break;

	      case MISSION_STATE_ACCOMPLISHED:
		/* Mission accomplished. */

		break;

              default:
		fprintf(
		    stderr,
 "SARSimEnd(): Unsupported mission progress state code `%i'\n",
		    mission->state
		);
                break;
            }
 
            SARMissionDestroy(core_ptr->mission);
            core_ptr->mission = NULL;
        }
        
        /* Delete scene. */
        SARSceneDestroy(
            core_ptr,
            core_ptr->scene,
            &core_ptr->object,
            &core_ptr->total_objects
        );
        free(core_ptr->scene);
        core_ptr->scene = NULL;

        /* Delete draw map object names list. */
        SARDrawMapObjNameListDelete(
            &core_ptr->drawmap_objname,
            &core_ptr->total_drawmap_objnames
        );


        if(option.runtime_debug)
            printf("SARSimEnd(): Switching back to menus...\n");

        /* Switch to 2D, select main menu (and thus redrawing it). */
	SARMenuGLStateReset(core_ptr->display);
        SARMenuButtonCBSelectMenu(core_ptr, SAR_MENU_NAME_MAIN);

        /* Restore keyboard auto repeat, this may be needed since a key
	 * may have been pressed to end a mission and while its held down
	 * the mission may end and auto repeat is not reset since the
	 * key release of the key in question is not handled when back in
	 * menus.
	 */
        GWKeyboardAutoRepeat(core_ptr->display, True);


        if(option.runtime_debug)
            printf("SARSimEnd(): Done.\n");

        return;
}
