#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>

#include "../include/string.h"
#include "../include/strexp.h"
#include "../include/os.h"

#include "gw.h"

#include "messages.h"

#include "cmd.h"
#include "sar.h"


void SARCommandOption(void *client_data, const char *arg);


#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))


/*
 *	Global option modification.
 */
void SARCommandOption(void *client_data, const char *arg)
{
	sar_core_struct *core_ptr = client_data;
	sar_scene_struct *scene;
	char **argv;
	int argc;
	char *parm, *val;


	if((core_ptr == NULL) ||
	   (arg == NULL)
	)
	    return;

	scene = core_ptr->scene;

        /* No argument given? */
        if((*arg) == '\0')
        {
            SARMessageAdd(
                scene,
                "Usage: option <parameter>=<value>"
            );
            return;
        }

	/* Parse arguments, format is:
	 *	<parameter>=<value>
	 */
	argv = strchrexp(arg, '=', &argc);
	if(argv == NULL)
	    return;

	/* First argument is option/parameter. */
	if(argc < 2)
	{
	    SARMessageAdd(
		scene,
		"Usage: option <parameter>=<value>"
	    );
	    StringFreeArray(argv, argc);
	    return;
	}

	/* Get links to parm and val in the strv array. */
	if(argc > 0)
	    parm = argv[0];
	else
	    parm = NULL;

	if(argc > 1)
	    val = argv[1];
        else
            val = NULL;

	if((parm == NULL) || (val == NULL))
	{
            SARMessageAdd(
                scene,
                "Usage: option <parameter>=<value>"
            );
            StringFreeArray(argv, argc);
            return;
        } 

	StringStripSpaces(parm);
	StringStripSpaces(val);


	/* ********************************************************* */
	/* Begin handling parm. */

	/* GL polygon offset factor. */
	if(!strcasecmp(parm, "gl_polygon_offset_factor") ||
           !strcasecmp(parm, "gl_polygon_offset")
	)
	{
	    option.gl_polygon_offset_factor = atof(val);
	}



	/* Deallocate exploded argument strings. */
	StringFreeArray(argv, argc);

	/* Links to parm and val strings are now invalid. */
	parm = NULL;
	val = NULL;

	return;
}
