#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "../include/string.h"
#include "../include/os.h"

#include "gw.h"
#include "messages.h"
#include "cmd.h"
#include "sar.h"

#include "config.h"


void SARCommandTextInputCB(void *client_data, const char *buffer);


/*
 *	Front end for handling text input. The text input comes from
 *	the prompt while `in game'.
 */
void SARCommandTextInputCB(void *client_data, const char *buffer)
{
	char *strptr, *arg_str;
	sar_core_struct *core_ptr = client_data;
	char cmd_str[SAR_CMD_MAX];
	void **cmd_list_ptr, *cmd_list[] = SAR_CMD_FUNC_REF_LIST;
	void (*cmd_func)(void *, char *);
	static int no_cmd_match = 0;


	if((core_ptr == NULL) ||
	   (buffer == NULL)
	)
	    return;


	/* Parse command string. */
	strncpy(cmd_str, buffer, SAR_CMD_MAX);
	cmd_str[SAR_CMD_MAX - 1] = '\0';
	strptr = strchr(cmd_str, ' ');
	if(strptr != NULL)
	    (*strptr) = '\0';

	/* Parse pointer to argument. */
	arg_str = strchr(buffer, ' ');
	if(arg_str == NULL)
	{
	    arg_str = "";
	}
	else
	{
	    while(ISBLANK(*arg_str))
		arg_str++;
	}

	/* Check which command function to call. */
	cmd_list_ptr = cmd_list;
	while((*cmd_list_ptr) != NULL)
	{
	    strptr = *cmd_list_ptr++;
	    cmd_func = *cmd_list_ptr;


	    if((strptr == NULL) ||
	       (cmd_func == NULL)
	    )
		break;

	    /* Commands match? */
	    if(!strcasecmp(strptr, cmd_str))
	    {
		cmd_func(core_ptr, arg_str);
		break;
	    }

	    cmd_list_ptr++;
	}
	/* Did we match a command? */
	if((*cmd_list_ptr) == NULL)
	{
	    no_cmd_match++;

	    if(no_cmd_match >= 3)
	    {
		char text[80 + SAR_CMD_MAX];


		sprintf(text,
"There is no such command `%s',\n\
please read the manual for a list of commands.",
		    cmd_str
		);
		GWOutputMessage(
		    core_ptr->display, GWOutputMessageTypeWarning,
		    "No Such Command",
		    text,
"Please read the help file or manual page for a list\n\
of commands."
		);

		no_cmd_match = 0;
	    }
	    else
	    {
		sar_scene_struct *scene = core_ptr->scene;
		char text[80 + SAR_CMD_MAX];


		if(scene != NULL)
		{
		    sprintf(
			text,
			"%s `%s'.",
			SAR_MESG_NO_SUCH_COMMAND, cmd_str
		    );
		    SARMessageAdd(scene, text);
		}
	    }
	}
	else
	{
	    /* Successfully matched command. */
	    no_cmd_match = 0;
	}

	return;
}
