/* ScummVM - Scumm Interpreter
 * Copyright (C) 2001  Ludvig Strigeus
 * Copyright (C) 2001-2006 The ScummVM project
 * Copyright (C) 2002-2006 Chris Apers - PalmOS Backend
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-0-9-1/backends/platform/PalmOS/Src/missing/ext_unistd.c $
 * $Id: ext_unistd.c 20887 2006-02-25 20:34:13Z chrilith $
 *
 */

#include <unistd.h>

const Char *gUnistdCWD = NULL;

// currently used only to retreive savepath
Char *getcwd(Char *buf, UInt32 size) {
	Char *copy = buf;

	if (gUnistdCWD) {
		if (!copy)
			copy = (Char *)MemPtrNew(StrLen(gUnistdCWD)); // this may never occured

		StrCopy(copy, gUnistdCWD);
	}

	return copy;
}