;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeinfo/main.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Oct 12 14:57:58 2001                          */
;*    Last change :  Wed Jan  9 11:27:26 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The entry point of the info->scribe translator                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module scribeinfo
   (import __scribeinfo_parser
	   __scribeinfo_lexer
	   __scribeinfo_engine
	   __scribeinfo_prelude
	   __scribeinfo_param)
   (main   main))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (define (usage args-parse-usage)
      (print "usage: scribeinfo [options] [input]")
      (newline)
      (args-parse-usage #f))
   (let ((stage 'scr)
	 (dest #f)
	 (in #f))
      (args-parse (cdr argv)
	 (("-h" "--help" (help "This help message"))
	  (usage args-parse-usage)
	  (exit 0))
	 ((("--options") (help "Display the options and exit"))
	  (args-parse-usage #t)
	  (exit 0))
	 (("--sexp" (help "Produce only s-expressions"))
	  (set! stage 'sexp))
	 (("-o" ?out (help "Set the destination file"))
	  (set! dest out))
	 (("--sui" ?info ?sui (help "Associate a SUI file with an INFO file"))
	  (set! *info-sui* (cons (cons info sui) *info-sui*)))
	 (else
	  (set! in else)))
      (if (string? dest)
	  (with-output-to-file dest (lambda () (scribeinfo in stage)))
	  (scribeinfo in stage))))

;*---------------------------------------------------------------------*/
;*    scribeinfo ...                                                   */
;*---------------------------------------------------------------------*/
(define (scribeinfo in stage)
   (let* ((port (if (string? in)
		    (open-input-file in)
		    (current-input-port)))
	  (sexp (parse-port port)))
      (if (eq? stage 'sexp)
	  (begin
	     (write sexp)
	     (newline))
	  (begin
	     (print "(style 'info)")
	     (for-each (lambda (e)
			  (write e)
			  (newline))
		       (scribeinfo-prelude))
	     (write (texi->scribe sexp))
	     (newline)))))

