;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/api.scm                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Sep 23 14:53:59 2001                          */
;*    Last change :  Tue Jan 15 11:30:27 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The scribe API                                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_api
   
   (include "pervasive.sch"
	    "markup.sch")
   
   (import  __scribeapi_prgm
	    __scribeapi_container
	    __scribeapi_io
	    __scribeapi_param
	    __scribeapi_backend
	    __scribeapi_ast
	    __scribeapi_configure
	    __scribeapi_rts
	    __scribeapi_sui
	    __scribeapi_index
	    __scribeapi_biblio)
   
   (eval    (export-exports))
   
   (export  (style . styles)
	    (include file)
	    (document . args)
	    (chapter . args)
	    (table-of-contents . args)
	    (author . args)
	    (section . args)
	    (subsection . args)
	    (subsubsection . args)
	    (paragraph . args)
	    (margin . args)
	    (linebreak . args)
	    (center . args)
	    (flush . args)
	    (bold . args)
	    (underline . args)
	    (emph . args)
	    (kbd . args)
	    (it . args)
	    (color . args)
	    (frame . args)
	    (tt . args)
	    (code . args)
	    (samp . args)
	    (var . args)
	    (sc . args)
	    (sub . args)
	    (sup . args)
	    (pre args)
	    (prgm . args)
	    (from-file . args)
	    (mark id)
	    (ref . args)
	    (mailto . args)
	    (item . args)
	    (itemize . args)
	    (enumerate . args)
	    (description . args)
	    (hrule . args)
	    (font . args)
	    (image . args)
	    (table . args)
	    (tr . args)
	    (th . args)
	    (td . args)
	    (copyright)
	    (space)
	    (tab)
	    (char char)
	    (hook . args)
	    (footnote . args)
	    (figure . args)
	    (make-index ::bstring)
	    (print-index . args)
	    (index . args)
	    (bibliography . bibs)
	    (print-bibliography . args)))

;*---------------------------------------------------------------------*/
;*    style ...                                                        */
;*---------------------------------------------------------------------*/
(define (style . styles)
   (define (load-style style)
      (let* ((name (cond
		      ((string? style)
		       style)
		      ((symbol? style)
		       (string-append (symbol->string style) ".scr"))))
	     (p (open-style-file name)))
	 (if (>fx *scribe-verbose* 0)
	     (fprint (current-error-port) "  [loading style: " name "]"))
	 (if (input-port? p)
	     (port->ast p)
	     (error "scribe" "Can't find style" style))))
   (for-each load-style styles))

;*---------------------------------------------------------------------*/
;*    document ...                                                     */
;*---------------------------------------------------------------------*/
(define-markup (document :title (:author '()) . body)
   ;; then, we allocate the document
   (let ((doc (set-parent! (instantiate::%document
			      (title title)
			      (authors (cond
					  ((null? author)
					   author)
					  ((pair? author)
					   author)
					  (else
					   (list author))))
			      (file (if (string? *scribe-dest*)
					*scribe-dest*
					""))
			      (body body)))))
      (with-access::%document doc (footnotes)
	 (set! footnotes (reverse! footnotes))
	 doc)
      (with-access::%document doc (children)
	 (let loop ((sn 1)
		    (cn 1)
		    (c children))
	    (cond
	       ((null? c)
		doc)
	       ((%section? (car c))
		(with-access::%section (car c) (number)
		   (if (number? number)
		       (loop (+fx number 1) cn (cdr c))
		       (if number
			   (begin
			      (set! number sn)
			      (loop (+fx sn 1) cn (cdr c)))
			   (loop sn cn (cdr c))))))
	       ((%chapter? (car c))
		(with-access::%chapter (car c) (number)
		   (if (number? number)
		       (loop sn (+fx number 1) (cdr c))
		       (if number
			   (begin
			      (set! number cn)
			      (loop cn (+fx cn 1) (cdr c)))
			   (loop sn cn (cdr c))))))
	       (else
		(loop sn cn (cdr c))))))))

;*---------------------------------------------------------------------*/
;*    author ...                                                       */
;*---------------------------------------------------------------------*/
(define-markup (author :name (:affiliation #f) (:email #f) (:url #f) (:address #f) (:phone #f) (:photo #f))
   (instantiate::%author
      (name name)
      (affiliation affiliation)
      (email email)
      (url url)
      (address address)
      (phone phone)
      (photo photo)))

;*---------------------------------------------------------------------*/
;*    section ...                                                      */
;*---------------------------------------------------------------------*/
(define-markup (section :title (:number #t) (:toc #t) . body)
   (let ((sec (set-parent! (instantiate::%section
			      (title (match-case title
					(((and ?str (? string?))) str)
					(else title)))
			      (body body)
			      (number number)
			      (toc toc)))))
      (block-set-numbers! (section-subsections sec))
      sec))

;*---------------------------------------------------------------------*/
;*    subsection ...                                                   */
;*---------------------------------------------------------------------*/
(define-markup (subsection :title (:number #t) . body)
   (let ((subsec (set-parent! (instantiate::%subsection
				 (title (match-case title
					   (((and ?str (? string?))) str)
					   (else title)))
				 (number number)
				 (body body)))))
      (block-set-numbers! (subsection-subsubsections subsec))
      subsec))

;*---------------------------------------------------------------------*/
;*    subsubsection ...                                                */
;*---------------------------------------------------------------------*/
(define-markup (subsubsection :title (:number #t) . body)
   (set-parent! (instantiate::%subsubsection
		  (title (match-case title
			    (((and ?str (? string?))) str)
			    (else title)))
		  (number number)
		  (body body))))

;*---------------------------------------------------------------------*/
;*    paragraph ...                                                    */
;*---------------------------------------------------------------------*/
(define-markup (paragraph . body)
   (set-parent! (instantiate::%paragraph
		   (body body))))

;*---------------------------------------------------------------------*/
;*    margin ...                                                       */
;*---------------------------------------------------------------------*/
(define-markup (margin (:bg #f) (:tbg #f) (:tfg #f) (:width #f) . body)
   (instantiate::%margin
      (bg bg)
      (tbg tbg)
      (tfg tfg)
      (width width)
      (body body)))

;*---------------------------------------------------------------------*/
;*    table-of-contents ...                                            */
;*---------------------------------------------------------------------*/
(define-markup (table-of-contents (:chapter #t) (:section #t))
   (instantiate::%toc
      (chapter chapter)
      (section section)))

;*---------------------------------------------------------------------*/
;*    chapter-counter ...                                              */
;*---------------------------------------------------------------------*/
(define *file-number* 0)

;*---------------------------------------------------------------------*/
;*    chapter ...                                                      */
;*---------------------------------------------------------------------*/
(define-markup (chapter (:title #f)
			(:subtitle #f)
			(:number #t)
			(:toc #t)
			(:file #t)
			. body)
   (cond
      ((and (not title) (not subtitle))
       (error "chapter" "should use either a :title or a :subtitle" body))
      (else
       ;; set the file to write that chapter
       (let ((file (cond
		      ((string? file)
		       file)
		      ((and file (string? *scribe-dest*))
		       (set! *file-number* (+fx 1 *file-number*))
		       (string-append (prefix *scribe-dest*)
				      "-"
				      (number->string *file-number*)
				      "."
				      (suffix *scribe-dest*)))
		      (file
		       (set! *file-number* (+fx 1 *file-number*))
		       (number->string *file-number*))
		      (else
		       #f))))
	  ;; allocate the new chapter
	  (let ((chap (set-parent! (instantiate::%chapter
				      (number number)
				      (title title)
				      (subtitle subtitle)
				      (file file)
				      (toc toc)
				      (body body)))))
	     (with-access::%chapter chap (footnotes children)
		(set! footnotes (reverse! footnotes))
		(block-set-numbers! children))
	     chap)))))

;*---------------------------------------------------------------------*/
;*    block-set-numbers! ...                                           */
;*---------------------------------------------------------------------*/
(define (block-set-numbers! children)
   (let loop ((n 1)
	      (c children))
      (if (pair? c)
	  (with-access::%block (car c) (number)
	     (cond
		((number? number)
		 (loop (+fx number 1) (cdr c)))
		((%paragraph? (car c))
		 (loop n (cdr c)))
		(else
		 (if number
		     (begin
			(set! number n)
			(loop (+fx n 1) (cdr c)))
		     (loop n (cdr c)))))))))

;*---------------------------------------------------------------------*/
;*    linebreak ...                                                    */
;*---------------------------------------------------------------------*/
(define-markup (linebreak . num)
   (instantiate::%linebreak
      (repetition (if (and (pair? num) (fixnum? (car num)))
		      (car num)
		      1))))

;*---------------------------------------------------------------------*/
;*    center ...                                                       */
;*---------------------------------------------------------------------*/
(define-markup (center . exp)
   (instantiate::%center
      (body exp)))

;*---------------------------------------------------------------------*/
;*    flush ...                                                        */
;*---------------------------------------------------------------------*/
(define-markup (flush (:side 'center) . exp)
   (instantiate::%flush
      (side side)
      (body exp)))

;*---------------------------------------------------------------------*/
;*    bold ...                                                         */
;*---------------------------------------------------------------------*/
(define-markup (bold . exp)
   (instantiate::%bold
      (body exp)))

;*---------------------------------------------------------------------*/
;*    underline ...                                                    */
;*---------------------------------------------------------------------*/
(define-markup (underline . exp)
   (instantiate::%underline
      (body exp)))

;*---------------------------------------------------------------------*/
;*    emph ...                                                         */
;*---------------------------------------------------------------------*/
(define-markup (emph . exp)
   (instantiate::%emph
      (body exp)))

;*---------------------------------------------------------------------*/
;*    kbd ...                                                          */
;*---------------------------------------------------------------------*/
(define-markup (kbd . exp)
   (instantiate::%kbd
      (body exp)))

;*---------------------------------------------------------------------*/
;*    it ...                                                           */
;*---------------------------------------------------------------------*/
(define-markup (it . exp)
   (instantiate::%it
      (body exp)))

;*---------------------------------------------------------------------*/
;*    color ...                                                        */
;*---------------------------------------------------------------------*/
(define-markup (color (:bg #f) (:fg #f) (:width #f) (:margin #f) . exp)
   (instantiate::%color
      (bg bg)
      (fg fg)
      (width width)
      (margin margin)
      (body exp)))

;*---------------------------------------------------------------------*/
;*    frame ...                                                        */
;*---------------------------------------------------------------------*/
(define-markup (frame (:width #f) (:margin #f) . exp)
   (instantiate::%frame
      (width width)
      (margin margin)
      (body exp)))

;*---------------------------------------------------------------------*/
;*    *figure-number* ...                                              */
;*---------------------------------------------------------------------*/
(define *figure-number* 0)

;*---------------------------------------------------------------------*/
;*    figure ...                                                       */
;*---------------------------------------------------------------------*/
(define-markup (figure :legend (:id #f) (:number #t) . exp)
   (let* ((number (cond
		     ((number? number)
		      number)
		     ((not number)
		      number)
		     (else
		      (set! *figure-number* (+fx 1 *figure-number*))
		      *figure-number*)))
	  (fig (instantiate::%figure
		  (number number)
		  (legend legend)
		  (body exp))))
      (list (if id (mark id) (mark legend)) fig)))

;*---------------------------------------------------------------------*/
;*    tt ...                                                           */
;*---------------------------------------------------------------------*/
(define-markup (tt . exp)
   (instantiate::%tt
      (body exp)))

;*---------------------------------------------------------------------*/
;*    code ...                                                         */
;*---------------------------------------------------------------------*/
(define-markup (code . exp)
   (instantiate::%code
      (body exp)))

;*---------------------------------------------------------------------*/
;*    samp ...                                                         */
;*---------------------------------------------------------------------*/
(define-markup (samp . exp)
   (instantiate::%samp
      (body exp)))

;*---------------------------------------------------------------------*/
;*    var ...                                                          */
;*---------------------------------------------------------------------*/
(define-markup (var . exp)
   (instantiate::%var
      (body exp)))

;*---------------------------------------------------------------------*/
;*    sc ...                                                           */
;*---------------------------------------------------------------------*/
(define-markup (sc . exp)
   (instantiate::%sc
      (body exp)))

;*---------------------------------------------------------------------*/
;*    sup ...                                                          */
;*---------------------------------------------------------------------*/
(define-markup (sup . exp)
   (instantiate::%sup
      (body exp)))

;*---------------------------------------------------------------------*/
;*    sub ...                                                          */
;*---------------------------------------------------------------------*/
(define-markup (sub . exp)
   (instantiate::%sub
      (body exp)))

;*---------------------------------------------------------------------*/
;*    pre ...                                                          */
;*---------------------------------------------------------------------*/
(define-markup (pre exp)
   (instantiate::%pre
      (body exp)))

;*---------------------------------------------------------------------*/
;*    prgm ...                                                         */
;*---------------------------------------------------------------------*/
(define-markup (prgm (:lnum #f) (:language #f) (:bg #f) (:frame #f) (:width 1.) . exp)
   (let* ((body (instantiate::%pre
		   (body (program exp lnum language))))
	  (cbody (if (string? bg)
		     (instantiate::%color
			(fg #f)
			(bg bg)
			(width width)
			(body body))
		     body)))
      (if frame
	  (instantiate::%frame
	     (body cbody)
	     (width width))
	  cbody)))

;*---------------------------------------------------------------------*/
;*    from-file ...                                                    */
;*---------------------------------------------------------------------*/
(define-markup (from-file (:definition #f) (:start #f) (:stop #f) file)
   `(from-file ,file ,definition ,start ,stop))

;*---------------------------------------------------------------------*/
;*    mark ...                                                         */
;*---------------------------------------------------------------------*/
(define-markup (mark id)
   (instantiate::%mark
      (id id)))

;*---------------------------------------------------------------------*/
;*    ref ...                                                          */
;*---------------------------------------------------------------------*/
(define-markup (ref (:scribe #f)
		    (:url #f)
		    (:id #f)
		    (:mark #f)
		    (:chapter #f)
		    (:section #f)
		    (:subsection #f)
		    (:subsubsection #f)
		    (:bib #f)
		    . title)
   (cond
      ((not (or (not id) (string? id)))
       (error "ref" "Illegal `id' value" id))
      ((not (or (not bib) (eq? bib '*) (string? bib)))
       (error "ref" "Illegal `bib' value" bib))
      ((not (or (not scribe) (string? scribe)))
       (error "ref" "Illegal `scribe' value" scribe))
      (scribe
       (let ((sui (find-file/path scribe *scribe-path*)))
	  (if (not (string? sui))
	      (if (not (eq? *scribe-format* 'sui))
		  (error "ref" "Can't open `scribe url index' file" scribe))
	      (multiple-value-bind (file anchor)
		 (scribe-url-index-search sui id mark chapter section subsection subsubsection)
		 (if (string? file)
		     (instantiate::%url-ref
			(url (if url (make-file-name url file) file))
			(anchor anchor)
			(body (if (null? title)
				  (or mark
				      chapter
				      section
				      subsection
				      subsubsection
				      scribe)
				  title)))
		     (begin
			(warning "ref" "Can't find scribe index -- " anchor)
			(bold (color :fg "#ff0000" "sui:???"))))))))
      (url
       (if (not (and url
		     (not chapter)
		     (not section)
		     (not subsection)
		     (not subsubsection)))
	   (error "ref" "Illegal `url' argument" url)
	   (instantiate::%url-ref
	      (url url)
	      (anchor id)
	      (body (if (null? title) url title)))))
      (chapter
       (if (not (and (or (%chapter? chapter) (string? chapter))
		     (not url)
		     (not section)
		     (not subsection)
		     (not subsubsection)))
	   (error "ref"
		  "Illegal `chapter' argument"
		  (cond
		     ((string? chapter)
		      chapter)
		     ((%chapter? chapter)
		      (or (%chapter-subtitle chapter)
			  (%chapter-title chapter)))
		     (else
		      (find-runtime-type chapter))))
	   (instantiate::%chapter-ref
	      (anchor chapter)
	      (body (if (pair? title) title #f)))))
      (section
       (if (not (and (or (%section? section) (string? section))
		     (not url)
		     (not chapter)
		     (not subsection)
		     (not subsubsection)))
	   (error "ref"
		  "Illegal `section' argument"
		  (cond
		     ((string? section)
		      section)
		     ((%section section)
		      (%section-title section))
		     (else
		      (find-runtime-type section))))
	   (instantiate::%section-ref
	      (anchor section)
	      (body (if (pair? title) title #f)))))
      (subsection
       (if (not (and (or (%subsection? subsection) (string? subsection))
		     (not url)
		     (not chapter)
		     (not section)
		     (not subsubsection)))
	   (error "ref"
		  "Illegal `subsection' argument"
		  (cond
		     ((string? subsection)
		      subsection)
		     ((%subsection? subsection)
		      (%subsection-title subsection))
		     (else
		      (find-runtime-type subsection))))
	   (instantiate::%subsection-ref
	      (anchor subsection)
	      (body (if (pair? title) title #f)))))
      (subsubsection
       (if (not (and (or (%subsubsection? subsubsection)
			 (string? subsubsection))
		     (not url)
		     (not chapter)
		     (not section)
		     (not subsection)))
	   (error "ref"
		  "Illegal `subsubsection' argument"
		  (cond
		     ((string? subsubsection)
		      subsubsection)
		     ((%subsubsection? subsubsection)
		      (%subsubsection-title subsubsection))
		     (else
		      (find-runtime-type subsubsection))))
	   (instantiate::%subsubsection-ref
	      (anchor subsubsection)
	      (body (if (pair? title) title #f)))))
      (mark
       (if (not bib)
	   (instantiate::%mark-ref
	      (anchor mark)
	      (body (if (null? title) mark title)))
	   (error "ref"
		  "Illegal `id' argument"
		  (if (%mark mark)
		      (%mark-id mark)
		      mark))))
      (id
       (if (not bib)
	   (instantiate::%unknown-ref
	      (anchor id)
	      (body (if (null? title) id title)))
	   (error "ref" "Illegal `id' argument" id)))
      (bib
       (if (not id)
	   (let ((entry (biblio-find bib)))
	      (if (%bibentry? entry)
		  (instantiate::%biblio-ref
		     (anchor entry)
		     (body (if (null? title) #f title)))
		  (begin
		     (warning "ref" "Can't find bib entry -- " bib)
		     (instantiate::%biblio-ref
			(anchor #f)
			(body (if (null? title) bib title))))))
	   (error "ref" "Illegal `bib' argument" bib)))
      ((null? title)
       (error "ref" "Missing argument" '()))
      (else
       (instantiate::%unknown-ref
	  (anchor title)))))

;*---------------------------------------------------------------------*/
;*    mailto ...                                                       */
;*---------------------------------------------------------------------*/
(define-markup (mailto (:email #f) . title)
   (instantiate::%mailto
      (email email)
      (body title)))

;*---------------------------------------------------------------------*/
;*    item ...                                                         */
;*---------------------------------------------------------------------*/
(define-markup (item (:key '()) . body)
   (instantiate::%item
      (value key)
      (body body)))

;*---------------------------------------------------------------------*/
;*    itemize ...                                                      */
;*---------------------------------------------------------------------*/
(define-markup (itemize . items)
   (for-each (lambda (i)
		(if (not (%item? i))
		    (error "itemize" "Illegal item" i)))
	     items)
   (instantiate::%itemize
      (items items)))

;*---------------------------------------------------------------------*/
;*    description ...                                                  */
;*---------------------------------------------------------------------*/
(define-markup (description . items)
   (for-each (lambda (i)
		(if (not (%item? i))
		    (error "description" "Illegal item" i)))
	     items)
   (instantiate::%description
      (items items)))

;*---------------------------------------------------------------------*/
;*    enumerate ...                                                    */
;*---------------------------------------------------------------------*/
(define-markup (enumerate . items)
   (for-each (lambda (i)
		(if (not (%item? i))
		    (error "enumerate" "Illegal item" i)))
	     items)
   (instantiate::%enumerate
      (items items)))

;*---------------------------------------------------------------------*/
;*    include ...                                                      */
;*---------------------------------------------------------------------*/
(define-markup (include file)
   (let ((fname (find-file/path file *scribe-path*)))
      (if (not (string? fname))
	  (error "include" "Can't find include file" file)
	  (begin
	     (if (>fx *scribe-verbose* 0)
		 (fprint (current-error-port) "  [including: " fname "]"))
	     (with-input-from-file fname
		(lambda () (port->ast (current-input-port))))))))

;*---------------------------------------------------------------------*/
;*    hrule ...                                                        */
;*---------------------------------------------------------------------*/
(define-markup (hrule (:width 1.) (:height 1))
   (instantiate::%hrule
      (width width)
      (height height)))

;*---------------------------------------------------------------------*/
;*    font ...                                                         */
;*---------------------------------------------------------------------*/
(define-markup (font (:size #f) (:face #f) . exp)
   (instantiate::%font
      (size size)
      (face face)
      (body exp)))

;*---------------------------------------------------------------------*/
;*    image ...                                                        */
;*---------------------------------------------------------------------*/
(define-markup (image :file (:width #f) (:height #f) (:zoom #f) . body)
   (if (not (string? file))
       (error "image" "Illegal filename" file)
       (instantiate::%image
	  (file file)
	  (width width)
	  (height height)
	  (body body)
	  (zoom zoom))))
	      
;*---------------------------------------------------------------------*/
;*    table                                                            */
;*---------------------------------------------------------------------*/
(define-markup (table (:border #f) (:width #f) (:cellpadding 0) . rows)
   (if (null? rows)
       (instantiate::%hrule)
       (begin
	  (for-each (lambda (r)
		       (if (not (%table-row? r))
			   (error "table" "Illegal row" r)))
		    rows)
	  (instantiate::%table
	     (border border)
	     (width width)
	     (cellpadding cellpadding)
	     (rows rows)))))

;*---------------------------------------------------------------------*/
;*    tr ...                                                           */
;*---------------------------------------------------------------------*/
(define-markup (tr (:bg #f) . cells)
   (for-each (lambda (c)
		(if (not (%table-cell? c))
		    (error "tr" "Illegal cell" c)))
	     cells)
   (instantiate::%table-row
      (bg bg)
      (cells cells)))

;*---------------------------------------------------------------------*/
;*    th ...                                                           */
;*---------------------------------------------------------------------*/
(define-markup (th (:width #f) (:align 'center) (:valign #f) (:bg #f)
		   (:rowspan 1) (:colspan 1)
		   . body)
   (instantiate::%table-header
      (width width)
      (align (cond
		((symbol? align) align)
		((string? align) (string->symbol align))
		(else (error "th" "Illegal align value" align))))
      (valign (cond
		 ((not valign) valign)
		 ((symbol? valign) valign)
		 ((string? valign) (string->symbol valign))
		 (else (error "th" "Illegal valign value" valign))))
      (body body)
      (rowspan rowspan)
      (colspan colspan)
      (bg bg)))

;*---------------------------------------------------------------------*/
;*    td ...                                                           */
;*---------------------------------------------------------------------*/
(define-markup (td (:width #f) (:align 'left) (:valign #f) (:bg #f)
		   (:rowspan 1) (:colspan 1)
		   . body)
   (instantiate::%table-data
      (width width)
      (align (cond
		((symbol? align) align)
		((string? align) (string->symbol align))
		(else (error "th" "Illegal align value" align))))
      (valign (cond
		 ((not valign) valign)
		 ((symbol? valign) valign)
		 ((string? valign) (string->symbol valign))
		 (else (error "th" "Illegal valign value" valign))))
      (body body)
      (rowspan rowspan)
      (colspan colspan)
      (bg bg)))

;*---------------------------------------------------------------------*/
;*    copyright ...                                                    */
;*---------------------------------------------------------------------*/
(define-markup (copyright)
   (instantiate::%character
      (value 'copyright)))

;*---------------------------------------------------------------------*/
;*    space ...                                                        */
;*---------------------------------------------------------------------*/
(define-markup (space)
   (instantiate::%character
      (value #\space)))

;*---------------------------------------------------------------------*/
;*    tab ...                                                          */
;*---------------------------------------------------------------------*/
(define-markup (tab)
   (instantiate::%character
      (value #\tab)))

;*---------------------------------------------------------------------*/
;*    hook ...                                                         */
;*---------------------------------------------------------------------*/
(define-markup (hook (:before #f) (:after #f) (:process #f) . body)
   (if (and before (not (procedure? before)))
       (bigloo-type-error "hook" "#f or procedure" before))
   (if (and after (not (procedure? after)))
       (bigloo-type-error "hook" "#f or procedure" after))
   (instantiate::%hook
      (body body)
      (before before)
      (after after)
      (process process)))

;*---------------------------------------------------------------------*/
;*    *footnote-number* ...                                            */
;*---------------------------------------------------------------------*/
(define *footnote-number* 0)

;*---------------------------------------------------------------------*/
;*    footnote ...                                                     */
;*---------------------------------------------------------------------*/
(define-markup (footnote :note (:number #f) . body)
   (let ((number (if number
		     number
		     (begin
			(set! *footnote-number* (+fx 1 *footnote-number*))
			*footnote-number*))))
      (instantiate::%footnote
	 (body body)
	 (note note)
	 (number number))))

;*---------------------------------------------------------------------*/
;*    char ...                                                         */
;*---------------------------------------------------------------------*/
(define (char char)
   (cond
      ((char? char)
       (string char))
      ((integer? char)
       (string (integer->char char)))
      (else
       (error "char" "Illegal char" char))))

;*---------------------------------------------------------------------*/
;*    *indexes* ...                                                    */
;*---------------------------------------------------------------------*/
(define *indexes* (list (cons "theindex" (make-hashtable))))

;*---------------------------------------------------------------------*/
;*    make-index ...                                                   */
;*---------------------------------------------------------------------*/
(define (make-index ident::bstring)
   (let ((cell (assoc ident *indexes*)))
      (if (pair? cell)
	  (error "make-index" "Illegal index redefinition" ident)
	  (set! *indexes* (cons (cons ident (make-hashtable)) *indexes*)))))

;*---------------------------------------------------------------------*/
;*    print-index ...                                                  */
;*---------------------------------------------------------------------*/
(define-markup (print-index (:split #t) (:char-offset 0) . indexes)
   (let* ((inames (if (null? indexes)
		      (list "theindex")
		      (map (lambda (n)
			      (if (not (string? n))
				  (error "print-index"
					 "arguments must be index name"
					 indexes)
				  n))
			   indexes)))
	  (indexes (map (lambda (n)
			   (let ((cell (assoc n *indexes*)))
			      (if (pair? cell)
				  (cdr cell)
				  (error "print-index" "Can't find index" n))))
			inames)))
      (if (not (and (integer? char-offset) (>= char-offset 0)))
	  (error "print-index" "Illegal char offset" char-offset)
	  (scribe-print-index split indexes char-offset))))

;*---------------------------------------------------------------------*/
;*    index ...                                                        */
;*---------------------------------------------------------------------*/
(define-markup (index (:note #f) (:index #f) (:shape #f) entry-name)
   (if (not (string? entry-name))
       (error "index" "There must be one string argument for index" entry-name)
       (let* ((index-name (if (not index)
			      "theindex"
			      index))
	      (cell (assoc index-name *indexes*)))
	  (if (pair? cell)
	      (let* ((table (cdr cell))
		     (table-name (car cell))
		     (new (instantiate::%index
			     (note note)
			     (shape (or shape entry-name))
			     (id (symbol->string (gensym table-name)))
			     (name entry-name))))
		 (hashtable-update! table
				    entry-name
				    (lambda (cur) (cons new cur))
				    (list new))
		 new)
	      (error "index" "Can't find index" index)))))

;*---------------------------------------------------------------------*/
;*    bigliography ...                                                 */
;*---------------------------------------------------------------------*/
(define (bibliography . files)
   (for-each (lambda (f)
		(cond
		   ((string? f)
		    (biblio-load f))
		   ((pair? f)
		    (biblio-add f))
		   (else
		    (error "bibliography" "Illegal entry" f))))
	     files))

;*---------------------------------------------------------------------*/
;*    print-bibliography ...                                           */
;*---------------------------------------------------------------------*/
(define-markup (print-bibliography (:all #f))
   (if all (biblio-all))
   (biblio-print-bib))
