/*  Screem:  xml.c,
 *
 *  some useful xml functions taken from Gnumeric.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include <gnome-xml/debugXML.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>

#include "xml.h"

/*
 * Search a child by name, if needed go down the tree to find it.
 * from gnumeric xml-io.c by Daniel Veillard <Daniel.Veillard@w3.org>
 */
xmlNodePtr xml_search_child( xmlNodePtr node, const char *name )
{
        xmlNodePtr ret;
        xmlNodePtr child;

        child = node->childs;
        while( child ){
                if( ! strcmp( child->name, name ) )
                        return child;
                child = child->next;
        }
        child = node->childs;
        while( child ) {
                ret = xml_search_child( child, name );
                if( ret )
                        return ret;
                child = child->next;
        }
        return NULL;
}

/*
 * Get a value for a node either carried as an attibute or as
 * the content of a child.
 * from gnumeric xml-io.c by Daniel Veillard <Daniel.Veillard@w3.org>
 */
char* xml_get_value( xmlNodePtr node, const char *name )
{
        char *ret;
        xmlNodePtr child;

        ret = (char*)xmlGetProp( node, name );
        if( ret )
                return ret;
        child = node->childs;

        while( child ) {
                if( ! strcmp( child->name, name ) ) {
                        /*
                         * !!! Inefficient, but ...
                         */
                        ret = xmlNodeGetContent( child );
                        if( ret )
				return ret;
                }
                child = child->next;
        }
        return NULL;
}
