/*  Screem:  galleryWizard.c,
 *  A wizard for creating image galleries
 *
 *  Copyright (C) 1999  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <dirent.h>

#include <gmodule.h>
#include <gnome.h>

#include "site.h"
#include "page.h"
#include "editor.h"
#include "fileops.h"

#include "gallery.xpm"

extern GtkWidget *app;
extern Site *current_site;

static GtkWidget* createDialog();
static void clicked( GtkWidget *widget, gint button, GtkWidget **dialog );
static void destroyed( GtkWidget *widget, GdkEvent *event, GtkWidget **dialog);
void galleryWizard();

static gint genPage( gint num, gint r, gint c, gint current, 
		     struct dirent **namelist, gint pageNum );

/*********************************************************************/
G_MODULE_EXPORT const gchar* 
g_module_check_init( GModule *module )
{
        g_print("galleryWizard: check-init\n");
        return NULL;
}
/*********************************************************************/
G_MODULE_EXPORT void
g_module_unload( GModule *module )
{
        g_print( "galleryWizard: unloaded\n" );
}
/*********************************************************************/

G_MODULE_EXPORT void 
init() 
{
	GtkWidget *galleryButton;
	GtkWidget *toolbar;

	toolbar = gtk_object_get_data( GTK_OBJECT( app ), "wizardbar" );

	/* place a button on the wizards toolbar */
        galleryButton = gnome_pixmap_new_from_xpm_d( GALLERY );
        gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), "",
                                 _("Image Gallery"), "", galleryButton ,
                                 galleryWizard, 0 );


	g_print( "galleryWizard: initialised\n" );
}
/*********************************************************************/
void galleryWizard()
{
	static GtkWidget *dialog = NULL;

        if( dialog ) {
                gdk_window_raise( dialog->window );
                gdk_window_show( dialog->window );
                return;
        }

        dialog = createDialog();
	gtk_signal_connect( GTK_OBJECT( dialog ), "clicked", clicked, &dialog);
	
        gtk_widget_show_all( dialog );
}
/*********************************************************************/
static GtkWidget* createDialog()
{
	GtkWidget *dialog;
	GtkWidget *dialog_vbox;
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *imagedir;
	GtkObject *cols_adj;
	GtkWidget *cols;
	GtkWidget *recurse;
	GtkObject *rows_adj;
	GtkWidget *rows;

	dialog = gnome_dialog_new( _("Gallery Wizard"),
				   GNOME_STOCK_BUTTON_OK,
				   GNOME_STOCK_BUTTON_CLOSE,
				   NULL );

	dialog_vbox = GNOME_DIALOG( dialog )->vbox;
 
	table = gtk_table_new( 2, 3, FALSE );
        gtk_box_pack_start( GTK_BOX( dialog_vbox ), table, TRUE, TRUE, 
			    GNOME_PAD );

	label = gtk_label_new( _("Rows:") );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2,
			  GTK_FILL, 0, GNOME_PAD, GNOME_PAD );
	gtk_label_set_justify( GTK_LABEL( label ), GTK_JUSTIFY_LEFT );
	gtk_misc_set_alignment( GTK_MISC( label ), 0, 0.5 );

	label = gtk_label_new( _("Image directory:") );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1,
			  GTK_FILL, 0, GNOME_PAD, GNOME_PAD );
	gtk_label_set_justify( GTK_LABEL( label ), GTK_JUSTIFY_LEFT );
	gtk_misc_set_alignment( GTK_MISC( label ), 0, 0.5 );

	label = gtk_label_new( _("Columns:") );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3,
			  GTK_FILL, 0, GNOME_PAD, GNOME_PAD );
	gtk_label_set_justify( GTK_LABEL( label ), GTK_JUSTIFY_LEFT );
	gtk_misc_set_alignment( GTK_MISC( label ), 0, 0.5 );

	imagedir = gnome_file_entry_new( "galleryDir",
					 _("Select Image Directory") );
	gtk_object_set_data( GTK_OBJECT( dialog ), "imagedir", imagedir );
        gtk_table_attach( GTK_TABLE( table ), imagedir, 1, 2, 0, 1,
			  0, 0, GNOME_PAD, GNOME_PAD );
	gnome_file_entry_set_directory( GNOME_FILE_ENTRY( imagedir ), TRUE );

	cols_adj = gtk_adjustment_new( 1, 0, 10, 1, 10, 10 );
	cols = gtk_spin_button_new( GTK_ADJUSTMENT( cols_adj ), 1, 0 );
	gtk_object_set_data( GTK_OBJECT( dialog ), "cols", cols );
	gtk_table_attach( GTK_TABLE( table ), cols, 1, 2, 2, 3,
			  0, 0, GNOME_PAD, GNOME_PAD );
	gtk_spin_button_set_numeric( GTK_SPIN_BUTTON( cols ), TRUE );

	rows_adj = gtk_adjustment_new( 1, 0, 10, 1, 10, 10 );
	rows = gtk_spin_button_new( GTK_ADJUSTMENT( rows_adj ), 1, 0 );
	gtk_object_set_data( GTK_OBJECT( dialog ), "rows", rows );
        gtk_table_attach( GTK_TABLE( table ), rows, 1, 2, 1, 2,
			  0, 0, GNOME_PAD, GNOME_PAD );
	gtk_spin_button_set_numeric( GTK_SPIN_BUTTON( rows ), TRUE );
	
	return dialog;
}
/*********************************************************************/
static void destroyed( GtkWidget *widget, GdkEvent *event, GtkWidget **dialog )
{
	*dialog = NULL;
}
/*********************************************************************/
static void clicked( GtkWidget *widget, gint button, GtkWidget **dialog )
{
	GtkWidget *imagedir;
	GtkWidget *rows;
	GtkWidget *cols;

	gchar *directory;
     	gint r;
	gint c;
	
	struct dirent **namelist;
	gint num;
	gint current = 0;
	gint pageNum = 1;

	gchar cwd[ 16384 ];

	imagedir = gtk_object_get_data( GTK_OBJECT( widget ), "imagedir" );
	rows = gtk_object_get_data( GTK_OBJECT( widget ), "rows" );
	cols = gtk_object_get_data( GTK_OBJECT( widget ), "cols" );

	if( button == 0 ) { /* OK */
		r = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON( rows ));
		c = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON( cols ));
		imagedir = gnome_file_entry_gtk_entry( GNOME_FILE_ENTRY( imagedir ) );
		directory = gtk_entry_get_text( GTK_ENTRY( imagedir ) );

		/* scan the directory for image files */
		num = scandir( directory, &namelist, 0, alphasort );

		getcwd( cwd, 16384 );
		chdir( directory );
		/* pages */
		while( current < num ) {
			current = genPage( num, r, c, current, namelist, 
					   pageNum );
			pageNum ++;
		}
		chdir( cwd );
	}

	*dialog = NULL;
	gtk_widget_destroy( widget );
}
/*********************************************************************/
static gint genPage( gint num, gint r, gint c, gint current,
		     struct dirent **namelist, gint pageNum )
{
	gchar *pageData;
	gint row;
	gint col;
	gchar *temp;
	gchar *filename;
	gchar *prefix;
	gchar *thumbfile;
	gint width, height;

	Page *p;
	GdkImlibImage *i, *i2;

	const gchar *mimeType;

	const gchar* header="<html>\n<head>\n<title></title>\n</head>\n<body bgcolor=\"white\">\n<center>\n";
	const gchar* footer="</center>\n</body>\n</html>";

	pageData = g_strdup_printf( "%s\n<table>\n", header );
	row = 0;
	col = 0;

	/* row */
	while( row < r ) {
		temp = pageData;
		pageData = g_strdup_printf( "%s<tr>\n", temp );
		g_free( temp );
		/* column */
		while( col < c ) {
			temp = pageData;
			do {
				filename = namelist[ current ]->d_name;
				current++;
				mimeType = gnome_mime_type_or_default( filename, "unknown" );
			} while( strncmp( mimeType, "image/", 6 ) && 
				 current < num );

			prefix = g_strndup( filename, 
					 g_extension_pointer( filename ) - 
					 filename - 1 );
			thumbfile = g_strdup_printf( "%s-thumb.%s", prefix, g_extension_pointer( filename ) );
			g_free( prefix );

			/* create the thumbnail */
			i = gdk_imlib_load_image( filename );
			width = i->rgb_width;
			height = i->rgb_height;
			width = 80;
			height = 60;
                        i2 = gdk_imlib_clone_scaled_image( i, width, height );
			gdk_imlib_destroy_image( i );
                        gdk_imlib_save_image( i2, thumbfile, NULL );
                        gdk_imlib_destroy_image( i2 );
			pageData = g_strdup_printf( "%s<td>\n<a href=\"%s\"><img src=\"%s\" alt=\"\" width=%i height=%i border=0 hspace=2 vspace=2></a></td>", temp, filename, thumbfile, width, height );
			g_free( thumbfile );
			g_free( temp );
			col ++;
			if( current == num )
				break;
		}
		col = 0;
		row ++;
		if( current >= num )
			break;
	}

	temp = pageData;
	pageData = g_strdup_printf( "%s</table>\n", temp );
	g_free( temp );

	temp = pageData;
	if( pageNum > 1 )
		pageData = g_strdup_printf( "%s<a href=\"gallery%i.html\">[Prev]</a>&nbsp;", temp, pageNum - 1 );
	else
		pageData = g_strdup_printf( "%s[Prev]&nbsp;", temp );
	g_free( temp );

	temp = pageData;
	if( current < num )
		pageData = g_strdup_printf( "%s<a href=\"gallery%i.html\">[Next]</a>", temp, pageNum + 1 );
	else
		pageData = g_strdup_printf( "%s[Next]", temp );
       	g_free( temp );
	
	/* page generated, save it */
	p = screem_page_new();
	screem_page_set_data( p, pageData );
	g_free( pageData );
	screem_page_set_pathname( p,
				  g_strdup_printf("gallery%i.html", pageNum) );
	screem_page_save( p );

	screem_page_destroy( p );
	return current;
}
