/*  Screem:  formWizard.c,
 *
 *  Copyright (C) 2000  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gmodule.h>
#include <gnome.h>

#include <glade/glade.h>

#include "site.h"
#include "page.h"
#include "editor.h"
#include "fileops.h"

#include "fixed.xpm"

extern GtkWidget *app;
extern Site *current_site;

static GladeXML *xml;

void formWizard();
void form_wizard_closed( GtkWidget *widget, GdkEvent *event, gpointer data );
void form_wizard_clicked( GtkWidget *widget, gint button, gpointer data );

/*********************************************************************/
G_MODULE_EXPORT const gchar* g_module_check_init( GModule *module )
{
        g_print("formWizard: check-init\n");
        return NULL;
}
/*********************************************************************/
G_MODULE_EXPORT void g_module_unload( GModule *module )
{
        g_print( "formWizard: unloaded\n" );
}

G_MODULE_EXPORT void init() 
{
        GtkWidget *formButton;
	GtkWidget *toolbar;

        GnomeUIInfo menuinfo[] = { 
                {
                        GNOME_APP_UI_ITEM, N_("Form..."),
                        N_("Insert a Form"),
                        formWizard, NULL, NULL,
                        GNOME_APP_PIXMAP_STOCK,
                        GNOME_STOCK_MENU_BLANK,
                        0,
                        GDK_CONTROL_MASK, NULL
                },
                GNOMEUIINFO_END
        };

   	toolbar = gtk_object_get_data( GTK_OBJECT( app ), "form_bar" );
        /* place menu item after form under insert */
        gnome_app_insert_menus( GNOME_APP( app ),
                                _("_Insert/"), menuinfo);

        /* place a button on the wizards toolbar */
        formButton = gnome_pixmap_new_from_xpm_d( fixed_xpm );
        gtk_toolbar_prepend_item( GTK_TOOLBAR( toolbar ), "",
				  _("Form Wizard"), "", formButton ,
				  formWizard, 0 );

        g_print( "formWizard: initialised\n" );
}

void formWizard()
{
	static GtkWidget *dialog = NULL;
	Page *page;

	page = screem_site_get_current_page( current_site );
	
	g_return_if_fail( page != NULL );
        
        if( dialog ) {
                gdk_window_raise( dialog->window );
                gdk_window_show( dialog->window );
                return;
        }

	xml = glade_xml_new( GLADE_PATH"/formWizard.glade",
			     "dialog1" );
	glade_xml_signal_autoconnect( xml );

	dialog = glade_xml_get_widget( xml, "dialog1" );

	gtk_object_set_data( GTK_OBJECT( dialog ), "dialog", &dialog );
}

void form_wizard_closed( GtkWidget *widget, GdkEvent *event, gpointer data )
{
	GtkWidget **d;

	d = gtk_object_get_data( GTK_OBJECT( widget ), "dialog" );
	if( d )
		*d = NULL;
}

void form_wizard_clicked( GtkWidget *widget, gint button, gpointer data )
{
	GtkWidget **d;
	GtkWidget *attr;

	gchar *method;
	gchar *action;
	gchar *enctype;

	gchar *open;
	gchar *close;

	d = gtk_object_get_data( GTK_OBJECT( widget ), "dialog" );

	if( button != 2 ) {
		/* ok or apply */
		attr = glade_xml_get_widget( xml, "method" );
		method = gtk_entry_get_text( GTK_ENTRY( attr ) );

		attr = glade_xml_get_widget( xml, "action" );
		action = gtk_entry_get_text( GTK_ENTRY( attr ) );

		attr = glade_xml_get_widget( xml, "enctype" );
		enctype = gtk_entry_get_text( GTK_ENTRY( attr ) );
		if( ! strcmp( "", enctype ) )
			enctype = NULL;

		if( enctype )
			open = g_strdup_printf( "<form method=\"%s\" action=\"%s\" enctype=\"%s\">\n", method, action, enctype );
		else
			open = g_strdup_printf( "<form method=\"%s\" action=\"%s\">\n", method, action );
		
		close = "\n</form>";

		screem_editor_insert_markup( open, close );

		g_free( open );
	}

	if( button == 0 || button == 2 ) {
		gtk_widget_destroy( widget );
		if( d )
			*d = NULL;
	}
}
