/*  Screem:  entityWizard.c,
 *  A wizard for entering special characters
 *
 *  Copyright (C) 1999  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */


#include <config.h>

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gmodule.h>
#include <gnome.h>

#include <glade/glade.h>

#include "site.h"
#include "page.h"
#include "editor.h"
#include "entities.h"

extern GtkWidget *app;
extern Site *current_site;

static GladeXML *xml = NULL;
static gint selected_row = -1;
static GtkWidget *dialog = NULL;

void entityWizard( void );
static void populate_lists();

void entity_row_selected( GtkCList *clist, gint row, gint column,
			  GdkEventButton *event, gpointer data );
void entity_dialog_clicked( GtkWidget *widget, gint button );

/*********************************************************************/
G_MODULE_EXPORT const gchar* g_module_check_init( GModule *module )
{
        g_print("entityWizard: check-init\n");
        return NULL;
}
/*********************************************************************/
G_MODULE_EXPORT void g_module_unload( GModule *module )
{
        g_print( "entityWizard: unloaded\n" );
}
/*********************************************************************/

G_MODULE_EXPORT void init() 
{
	GnomeUIInfo menuinfo[] = { 
                {
                        GNOME_APP_UI_ITEM, N_("Entity..."),
                        N_("Insert a special character entity"),
                        entityWizard, NULL, NULL,
                        GNOME_APP_PIXMAP_STOCK,
                        GNOME_STOCK_MENU_BLANK,
                        0,
                        GDK_CONTROL_MASK, NULL
                },
                GNOMEUIINFO_END
        };

	/* place menu item after image under insert */
        gnome_app_insert_menus( GNOME_APP( app ),
                                _("_Insert/"), menuinfo);

	g_print( "entityWizard: initialised\n" );
}
/*********************************************************************/
void entityWizard()
{
	Page *page;
 
	page = screem_site_get_current_page( current_site );
        
        g_return_if_fail( page != NULL );

	if( dialog ) {
                gdk_window_raise( dialog->window );
                gdk_window_show( dialog->window );
                return;
        }

	xml = glade_xml_new( GLADE_PATH"/entityWizard.glade",
			     "ent_wizard" );
        glade_xml_signal_autoconnect( xml );

        dialog = glade_xml_get_widget( xml, "ent_wizard" );

	populate_lists( dialog );
}
/*********************************************************************/
static void populate_lists()
{
	GtkWidget *list;
	gint num;
	gchar *items[ 3 ] = { NULL, NULL, NULL };

	list = glade_xml_get_widget( xml, "iso_list" );

	/* insert the entities */
	for( num = 0; ISO_8859_1[ num ]; num ++ ) {
		items[ 0 ] = ISO_8859_1[ num ];
		items[ 1 ] = ISO_8859_1[ num ];
		gtk_clist_append( GTK_CLIST( list ), items );
	}

	list = glade_xml_get_widget( xml, "math_list" );

	/* insert the entities */
	for( num = 0; MATH_GREEK_SYMBOLIC[ num ]; num ++ ) {
		items[ 0 ] = MATH_GREEK_SYMBOLIC[ num ];
		items[ 1 ] = MATH_GREEK_SYMBOLIC[ num ];
		gtk_clist_append( GTK_CLIST( list ), items );
	}

	list = glade_xml_get_widget( xml, "markup_list" );

	/* insert the entities */
	for( num = 0; MARKUP_INTL[ num ]; num ++ ) {
		items[ 0 ] = MARKUP_INTL[ num ];
		items[ 1 ] = MARKUP_INTL[ num ];
		gtk_clist_append( GTK_CLIST( list ), items );
	}
}
/***********************************************************************/
void entity_row_selected( GtkCList *clist, gint row, gint column,
			  GdkEventButton *event, gpointer data )
{
	gint pos;
	gchar *text;
	gchar *info[ 1 ];

	selected_row = row;

	if( event->type == GDK_2BUTTON_PRESS ) {
		gtk_clist_get_text( clist, row, 1, &info[ 0 ] );
		
		pos = screem_editor_get_pos();
		text = g_strdup_printf( "&%s;", info[ 0 ] );
		screem_editor_insert( pos, text );
		screem_editor_set_pos( pos + strlen( text ) );
		g_free( text );
	}
}
/**************************************************************************/
void entity_dialog_clicked( GtkWidget *widget, gint button )
{
	gtk_widget_destroy( widget );
	dialog = NULL;
}
