#ifndef MATHML_H
#define MATHML_H

/* MathML Presentation markup */

static gchar *ptoken_elements[] = {
	"mi",
	"mn",
	"mo",
	"mtext",
	"mspace",
	"ms",
	NULL
};

static gchar *pgeneral_layout[] = {
	"mrow",
	"mfrac",
	"msqrt",
	"mstyle",
	"merror",
	"mpadded",
	"mphantom",
	"mfenced",
	NULL
};

static gchar *pscript_limit[] = {
	"msub",
	"msup",
	"msubsup",
	"munder",
	"mover",
	"munderover",
	"mmultiscripts",
	NULL
};

static gchar *ptables_matrices[] = {
	"mtable",
	"mtr",
	"mtd",
	"maligngroup",
	"malignmark",
	NULL
};

static gchar *penlivening[] = {
	"maction",
	NULL
};

/* MathML Content markup */

static gchar *ctoken_elements[] = {
	"cn",
	"ci",
	NULL
};

static gchar *cbasic_elements[] = {
	"apply",
	"reln",
	"fn",
	"interval",
	"inverse",
	"sep",
	"condition",
	"declare",
	"lambda",
	"compose",
	"ident",
	NULL
};

static gchar *carithmetic_algebra_logic[] = {
	"quotient",
	"exp",
	"factorial",
	"divide",
	"max",
	"min",
	"minus",
	"plus",
	"power",
	"rem",
	"times",
	"root",
	"gcd",
	"and",
	"or",
	"xor",
	"not",
	"implies",
	"forall",
	"exists",
	"abs",
	"conjugate",
	NULL
};

static gchar *crelations[] = {
	"eq",
	"neq",
	"gt",
	"lt",
	"geq",
	"leq",
	NULL
};

static gchar *ccalculus[] = {
	"ln",
	"log",
	"int",
	"diff",
	"partialdiff",
	"lowlimit",
	"uplimit",
	"bvar",
	"degree",
	NULL
};

static gchar *ctheory_of_sets[] = {
	"set",
	"list",
	"union",
	"intersect",
	"in",
	"notin",
	"subset",
	"prsubset",
	"notsubset",
	"notprsubset",
	"setdiff",
	NULL
};

static gchar *csequences_series[] = {
	"sum",
	"product",
	"limit",
	"tendsto",
	NULL
};

static gchar *ctrigonometry[] = {
	"sin",
	"cos",
	"tan",
	"sec",
	"csc",
	"cot",
	"sinh",
	"cosh",
	"tanh",
	"sech",
	"csch",
	"coth",
	"arcsin",
	"arccos",
	"arctan",
	NULL
};

static gchar *cstatistics[] = {
	"mean",
	"sdev",
	"variance",
	"median",
	"mode",
	"moment",
	NULL
};

static gchar *clinear_algebra[] = {
	"vector",
	"matrix",
	"matrixrow",
	"determinant",
	"transpose",
	"selector",
	NULL
};

static gchar *csemantic_mapping[] = {
	"annotation",
	"semantics",
	"annotation-xml",
	NULL
};

#endif
