#ifndef PAGEUI_H
#define PAGEUI_H

#include "screem-page.h"
#include "screem-site.h"

#include "screem-window.h"
#include "screem-editor.h"

enum {
	SAVE_AS_FAILED,
	SAVE_AS_CANCELLED,
	SAVE_AS_OK
};

gboolean screem_page_open_with_filename( ScreemSite *site, 
					 ScreemWindow *window,
					 const gchar *filename );
gint screem_page_save_as( ScreemPage *page, ScreemWindow *window,
		const gchar *dir, ScreemApplication *app );
gint screem_page_save_confirmation( ScreemPage *page, 
		ScreemWindow *window, gboolean closing );
void screem_page_create_blank_page( ScreemSite *site );
gboolean screem_page_close_page( ScreemPage *page, ScreemWindow *window,
				gboolean confirm );
void build_recent_pages_menu( void );

gboolean screem_page_save_check( ScreemPage *page );
gchar *screem_page_id_charset( ScreemPage *page );

void external_view( ScreemPage *page );

void screem_page_edit_bookmarks( ScreemWindow *window, ScreemEditor *editor,
				 ScreemPage *page );


gint screem_page_save_page_confirmation( ScreemPage *page,
		ScreemWindow *window, ScreemApplication *app );
gint screem_page_save_pages_confirmation( GSList *pages,
		ScreemWindow *window, ScreemApplication *app );


#endif
