#ifndef SUPPORT_H
#define SUPPORT_H

#include <gtk/gtk.h>

void change_state( GtkWidget *widget, gpointer data );
void change_visible( GtkWidget *widget, gpointer data );

char * convert_keysym_state_to_string( guint keysym, guint state );

gchar *screem_support_ctags( const gchar *dirname, const gchar *word,
			     gchar **pattern );
gchar *screem_support_escape_regexp( const gchar *pattern );

GtkTreeIter *screem_support_find_in_list( GtkListStore *store, 
					  guint column, const gchar *str );

gchar *screem_support_charset_convert( const gchar *data, guint len,
										gchar **data_charset );
gchar *screem_support_charset_convert_to( const gchar *data, 
					const gchar *charset,
					const gchar *from );

gchar *screem_get_mime_type( const gchar *filename, gboolean fast );
gchar *screem_get_mime_type_override( const gchar *filename,
					const gchar *type ); 

const gchar *g_utf8_skip_space( const gchar *txt );
const gchar *screem_utf8_skip_to_space( const gchar *txt );
	
gchar* screem_escape_underlines( const gchar* text );

gboolean screem_execute_default_app( const gchar *uri );

void g_string_append_utf8_len( GString *str, const gchar *utf8,
				guint len );
GtkPositionType screem_get_tab_position( void );

void screem_set_cursor( GtkWidget *widget, GdkCursorType type );

void screem_popup_menu_do_popup_modal( GtkWidget *popup, 
		GtkMenuPositionFunc pos_func, gpointer pos_data,
		GdkEventButton *event, gpointer user_data, 
		GtkWidget *for_widget );

GtkFileFilter *screem_get_file_filter( const gchar *name );

gchar *screem_get_glade_path( void );

gboolean screem_find_accel( GtkAccelGroup *group, GdkEventKey *event );

gint screem_mime_type_compare( gconstpointer a, gconstpointer b );

void screem_hig_alert( const gchar *stock_id,
		const gchar *primary, const gchar *secondary,
		GtkWidget *parent );

GtkListStore *screem_support_get_mime_types_store( void );

gchar *screem_gdk_color_to_string( GdkColor *colour );

gchar* screem_escape_char( const gchar* text, gchar c );

#endif
