/* Score Reading Trainer
   Copyright (C) 2004,2005,2006,2007 by José Pablo Ezequiel Fernández Silva <pupeno@pupeno.com>

   This file is part of Score Reading Trainer.

   Score Reading Trainer is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

   Score Reading Trainer is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

#ifndef _PREFERENCES_H_
#define _PREFERENCES_H_

#include <kdialogbase.h>

class Program;

class Preferences : public KDialogBase {
	Q_OBJECT
	public:
		Preferences();

	private:
		/**
		 * Load the configuration to the dialog
		 */
		void loadSettings();

		/**
		 * Widget of the preferences
		 */
		Program *program;

	private slots:
		/**
		 * Save the settings to the KConfig
		 */
		void saveSettings();

		/**
		 * Put the default settings on the configuration dialog.
		 */
		void defaultSettings();
};

#endif // _PREFERENCES_H_
