/***************************************************************************
 *   copyright           : (C) 2004 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own headers
#include <helper.h>
#include <smspdu.h>

//standard headers
#include <string.h>

void struct_sms_pdu_message_status_init(struct sms_pdu_message_status* s)
{
  s->s = 0;
  struct_sms_pdu_time_init(&s->t);
  s->message_parent = NULL;
  s->status_parent = NULL;
}

void struct_sms_number_init (struct sms_number* s) {
  if (s == NULL) return;
  s->type = 0;
  memset(s->digits,0,sizeof(s->digits));
  s->text = NULL;
}
void struct_sms_number_delete (struct sms_number* s) {
  if (s == NULL) return;
  mem_realloc(s->text,0);
}

int struct_sms_number_compare (const struct sms_number* s1, 
			       const struct sms_number* s2)
{
  if (s1->type == s2->type
      && ((str_len(s1->digits) == 0 && str_len(s2->digits) == 0)
	  || strcmp(s1->digits,s2->digits) == 0)
      && ucs4cmp(s1->text,s2->text) == 0) {
    return 1;
  } else {
    return 0;
  }
}

void struct_sms_pdu_time_init (struct sms_pdu_time* s) {
  if (s == NULL) return;
  s->format = SMS_PDU_TIME_NONE;
  s->value = 0;
}

void struct_sms_pdu_ud_header_init (struct sms_pdu_ud_header* s) {
  if (s == NULL) return;
  s->type = 0;
  s->len = 0;
  s->data = NULL;
}
void struct_sms_pdu_ud_header_delete (struct sms_pdu_ud_header* s) {
  if (s == NULL) return;
  mem_realloc(s->data,0);
}

void struct_sms_pdu_ud_init (struct sms_pdu_ud* s) {
  if (s == NULL) return;
  s->header = NULL;
  s->text = NULL;
  s->ack = NULL;
}
void struct_sms_pdu_ud_delete (struct sms_pdu_ud* s) {
  unsigned int i = 0;
  if (s == NULL) return;
  if (s->header != NULL) {
    while (s->header[i] != NULL) {
      struct_sms_pdu_ud_header_delete(s->header[i]);
      mem_realloc(s->header[i],0);
      ++i;
    }
    mem_realloc(s->header,0);
  }
  mem_realloc(s->text,0);
}

void struct_sms_pdu_options_init (struct sms_pdu_options* s) {
  s->mms = 0;
  s->rd = 0;
  s->rp = 0;
  s->sr = 0;
  s->udh_present = 0;
}

void struct_sms_pdu_dcs_init (struct sms_pdu_dcs* s) {
  s->dcs_present = 0;
  s->encoding = SMS_CHARSET_GSM;
  s->compressed = 0;
  s->autodel = 0;
  s->options = SMS_DCS_OPT_NONE;
  s->class = 0;
  s->indgroup = SMS_DCS_IND_STORE;
  s->indsense = 0;
  s->indtype = SMS_DCS_IND_OTHER;
}

void struct_sms_pdu_data_init (struct sms_pdu_data* s) {
  if (s == NULL) return;
  struct_sms_pdu_options_init(&s->options);
  struct_sms_number_init(&s->address);
  s->pid = 0;
  struct_sms_pdu_dcs_init(&s->scheme);
  struct_sms_pdu_time_init(&s->timedata);
  s->multipart_id = 0;
  s->partnum = 0;
  s->parts = 0;
  s->ud = NULL;
  s->status = NULL;
}
void struct_sms_pdu_data_delete (struct sms_pdu_data* s) {
  unsigned int i = 0;
  if (s == NULL) return;
  struct_sms_number_delete(&s->address);
  if (s->ud != NULL) {
    while (i < s->parts) {
      struct_sms_pdu_ud_delete(&s->ud[i++]);
    }
    mem_realloc(s->ud,0);
  }
  if (s->status != NULL &&
      (s->options.type == SMS_TYPE_STATUS_REPORT ||
       s->status->status_parent == NULL)) {
    mem_realloc(s->status,0);
  }
}

void struct_sms_tpdu_data_init (struct sms_tpdu_data* s) {
  if (s == NULL) return;
  struct_sms_number_init(&s->sca);
  s->pdu = NULL;
}
void struct_sms_tpdu_data_delete (struct sms_tpdu_data* s) {
  if (s == NULL) return;
  struct_sms_number_delete(&s->sca);
  if (s->pdu != NULL) {
    struct_sms_pdu_data_delete(s->pdu);
    mem_realloc(s->pdu,0);
  }
}

void struct_sms_slot_data_init (struct sms_slot_data* s) {
  if (s == NULL) return;
  s->slot = 0;
  memset(s->tpdu,0,sizeof(s->tpdu));
}

void struct_sms_init (struct sms* s,
		      struct sms_slot_data* encoded,
		      struct sms_tpdu_data* decoded)
{
  unsigned int i;
  unsigned int p = 2;
  if (s == NULL || encoded == NULL ||
      decoded == NULL || decoded->pdu == NULL) {
    return;
  }
  if (decoded->pdu->parts > 0) p = decoded->pdu->parts+1;
  s->encoded = mem_alloc(p*sizeof(*(s->encoded)),0);
  for (i = 0; i < p; ++i) {
    s->encoded[i] = NULL;
  }
  s->encoded[decoded->pdu->partnum] = encoded;
  s->decoded = decoded;
}
void struct_sms_delete (struct sms* s) {
  unsigned int i = 0;
  if (s == NULL) return;
  if (s->encoded != NULL) {
    while (s->encoded[i] != NULL) {
      mem_realloc(s->encoded[i],0);
      ++i;
    }
    mem_realloc(s->encoded,0);
  }
  if (s->decoded != NULL) {
    struct_sms_tpdu_data_delete(s->decoded);
    mem_realloc(s->decoded,0);
  }
}
