/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own headers
#include <charsets.h>
#include <helper.h>
#include "ucs2.h"

//standard headers
#include <stdio.h>
#include <string.h>

ucs4char_t* convert_from_ucs2 (ucs2char_t* input) {
  return convert_to_internal(ucs2_get_iconv_charset(),
			     (unsigned char*)input,
			     ucs2len(input)*sizeof(ucs2char_t));
}

ucs4char_t* convert_from_ucs2_hexstring (char* input) {
  ucs4char_t* retval;
  ucs2char_t* temp;
  unsigned int i;

  if (input == NULL) return NULL;
  temp = mem_alloc(((strlen(input)/4)+1)*sizeof(ucs2char_t),1);
  for (i = 0; ((i+1)*4) <= strlen(input); ++i) {
    temp[i]=hexstr2int(input+(i*4),4);
  }

  retval = convert_from_ucs2(temp);
  mem_realloc(temp,0);
  return retval;
}
