/***************************************************************************
                          s35_pbook.c  -  description
                             -------------------
    copyright            : (C) 2001 by Hendrik Sattler
    email                : post@hendrik-sattler.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"

void pbook_s35(int action, char* file, char* phonebook){
    char at_command[11];
    char ack[BUFSIZ];

    memset(at_command,0,sizeof(at_command));
    memset(ack,0,sizeof(ack));
	
    //selecting phonebook
    if (!strcmp(get_vendor(),"SIEMENS")) {
	new_at_command(at_command,"^SPBS=");
    } else {
	new_at_command(at_command,"+CPBS=");
    }
    add_at_command(at_command,phonebook);
    com_mytty(at_command,ack);
    if (strcmp(ack,"OK")) {
	errexit("%s, cannot select phonebook %s\n",ack,phonebook);
    }
	
    switch (action) {
	default:
		errexit("You must specify exactly one operation.\n");
		break;
		
	case 2: //deleting
		delete_pb_s35(phonebook);
		break;
	
	case 4: //sending
		send_pb_s35(file,phonebook);
		break;
		
	case 8: //getting
		get_pb_s35(file,phonebook);
		break;
    }
}

void delete_pb_s35 (char* phonebook) {
    char at_command[BUFSIZ];
    char ausgabe[BUFSIZ];
    char ack[BUFSIZ];
    int i,first_entry,last_entry;

    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));
    memset(ack,0,sizeof(ack));

    if ((!strcasecmp(phonebook,"DC"))||(!strcasecmp(phonebook,"MD"))
          ||(!strcasecmp(phonebook,"LD"))){
        new_at_command(at_command,"^SDLD");
        com_mytty(at_command,ack);
        if (!strcmp(ack,"OK")) {
	    myprintf(0,"%s deleted.\n",phonebook);
	} else {
	    errexit("\n%s\nAn ERROR occured. Possible data corruption!\n",ack);
	}				
    } else {
	new_at_command(at_command,"+CPBW=?");
	com_mytty(at_command,ausgabe);
	if (!strcmp(ausgabe,"+CME ERROR: OPERATION NOT SUPPORTED")) {
	    errexit("You cannot delete the content of %s\n",phonebook);
	} else {
	    read_mytty(at_command,ack);
	}
	first_entry=atoi((char *)strtok(&ausgabe[7],"(-),"));
	last_entry=atoi((char *)strtok(NULL,"(-),"));
	myprintf(0,"Preparing to delete %d entries\n",last_entry);
	myprintf(0,"Deleting: ");
	for (i=first_entry;i<=last_entry;i++) {
	    new_at_command(at_command,"+CPBW=");
	    add_at_command(at_command,"%d",i);
	    com_mytty(at_command,ack);
	    if (!strcmp(ack,"OK")) {
		myprintf(0,"%d ",i);
	    } else {
		errexit("\n%s\nAn ERROR occured. Possible data corruption!\n",ack);
	    }				
	}
	myprintf(0,"\n");
    }

}

void send_pb_s35 (char* file, char* phonebook) {
    char at_command[BUFSIZ];
    char ausgabe[BUFSIZ];
    char ack[BUFSIZ];
    char temp[BUFSIZ];
    unsigned char *token=NULL;
    unsigned char buffer;
    int myfd,
	i,
	first_entry,
	current_entry,
	last_entry,
	nr_length,
	text_length,
	bytecount;

    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));
    memset(ack,0,sizeof(ack));
    memset(temp,0,sizeof(temp));

    new_at_command(at_command,"+CPBW=?");
    com_mytty(at_command,ausgabe);
    if (!strcmp(ausgabe,"+CME ERROR: OPERATION NOT SUPPORTED")) {
        errexit("You cannot write to %s\n",phonebook);
    } else {
	read_mytty(at_command,ack);
    }
    first_entry=atoi((char *)strtok(&ausgabe[7],"(-),"));
    last_entry=atoi((char *)strtok(NULL,"(-),"));
    nr_length=atoi((char *)strtok(NULL,"(-),"));
    strtok(NULL,","); //not needed (we know the type numbers)
    text_length=atoi((char *)strtok(NULL,"(-),"));
	
    myfd=open_myFile_ro(file);
	
    myprintf(0,"Preparing to send %d entries\n",last_entry);
    myprintf(0,"Sending: ");
    for (i=first_entry;i<=last_entry;i++) {
        //reading the entries from the file
        memset(temp,0,sizeof(temp));
	bytecount=0;
	do {
	    if (read(myfd,&buffer,1)!=1) {
	        close(myfd);
	        if (bytecount==0) {
		    myprintf(0,"\nIncomplete phonebook sent.\n");
		    return;
		} else {
		    errexit("\nError reading %s or unexpected end of file.\n",file);
		}
	    }
	    if (buffer!='\n') {
		temp[bytecount]=buffer;
	    }
	    if (bytecount+1<sizeof(temp)) {
	        bytecount++;
	    } else {
		close(myfd);
		errexit("\nBuffer overflow, aborting\n");
	    }
	} while (buffer!='\n');
	
	//checking string
	strcpy(ausgabe,temp);
	if (atoi(ausgabe)==0 || atoi(ausgabe)>last_entry) {//the line must begin with a valid number
	    close(myfd);
	    errexit("\nError, invalid entry.\n");
	}
	if (strstr(ausgabe,",\"")==NULL) {
	    close(myfd);
	    errexit("\nError, invalid entry.\n");
	} else {
	    token=strstr(ausgabe,",\"")+2;
	}
	if (strstr(ausgabe,"\",\"")==NULL) {
	    close(myfd);
	    errexit("\nError, invalid entry.\n");
	} else {
	    token=strstr(ausgabe,"\",\"")+3;
	}
	buffer=token[strlen(token)-1];
	if (buffer!='"') {
	    close(myfd);
	    errexit("\nError, invalid entry.\n");
	}				
	//end of checking string
				
	new_at_command(at_command,"+CPBW=");
	current_entry=atoi(temp);
	strtok(temp,",");
	add_at_command(at_command,"%d",current_entry);
	//analyse token 2
	token=(char *)strtok(NULL,",");
	if (strlen(token)>nr_length+2) {
	    close(myfd);
	    errexit("\nError, number of entry %d is too long (max. %d)\nAlready sent entries are o.k.\n",i,nr_length);
	} else if (2<(strlen(token)) && (strlen(token)<=nr_length+2)) {
	    //add token 2
	    add_at_command(at_command,",");
	    add_at_command(at_command,token);
	    //add token 3
	    buffer=token[1];
	    if (buffer=='+') {
	        add_at_command(at_command,",145,");
	    } else {
	        add_at_command(at_command,",129,");
	    }
	    //convert, test and add token 4
	    token=(char *)strtok(NULL,"");
	    iso2gsm(token);
	    if (strlen(token)>text_length+2) {
	        close(myfd);
	        errexit("\nError, text of entry %d is too long (max. %d)\nAlready sent entries are o.k.\n",i,text_length);
	    }
	    mask_pbook_chars(token);
	    add_at_command(at_command,token);
	} else if(strlen(token)<=2) {
	}
	com_mytty(at_command,ack);
	if (!strcmp(ack,"OK")) {
	    myprintf(0,"%d ",current_entry);
	} else {
	    close(myfd);
	    errexit("\n%s\nAn ERROR occured. Possible data corruption!\n",ack);
	}
    }
    myprintf(0,"\n");
    close(myfd);
}

void get_pb_s35 (char* file, char* phonebook) {
    char at_command[BUFSIZ];
    char ausgabe[BUFSIZ];
    char ack[BUFSIZ];
    char temp[BUFSIZ];
    unsigned char *token=NULL;
    int myfd,i,first_entry,current_entry,last_entry;

    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));
    memset(ack,0,sizeof(ack));
    memset(temp,0,sizeof(temp));

    //reading available indexes
    new_at_command(at_command,"+CPBR=?");
    write_mytty(at_command);
    read_mytty(at_command,ausgabe);
    if (strstr(ausgabe,"ERROR")==NULL) {
	read_mytty(at_command,ack);
    } else {
	errexit("Error: Could not get phonebook index list\n");
    }
    if (!strncmp(ausgabe,"+CPBR: ",7)) {
	first_entry=atoi((char *)strtok(&ausgabe[7],"(-)"));
	last_entry=atoi((char *)strtok(NULL,"(-)"));
    } else {
	errexit("Error: Invalid phonebook index list\n");
    }
					
    //accessing file
    if (strlen(file)) {
	myfd=open_myFile_rw(file);
    }
    //getting the data
    memset(ausgabe,0,sizeof(ausgabe));
    if ((!strcasecmp(phonebook,"RD"))||(!strcasecmp(phonebook,"CS"))) {
        new_at_command(at_command,"^SPBG=");
    } else {
        new_at_command(at_command,"+CPBR=");
    }
    sprintf(temp,"%d,%d",first_entry,last_entry);
    add_at_command(at_command,temp);
    com_mytty(at_command,ausgabe);
    if (strstr(ausgabe,"ERROR")!=NULL) {
	errexit("Error on selecting phonebook\n");
    }
    current_entry=first_entry;
    myprintf(0,"Receiving:");
    if (!strcmp(file,"-")) {
	myprintf(0,"\n");
    }
    //read until OK or ERROR
    while (strcmp(ausgabe,"OK")
         && strcmp(ausgabe,"ERROR")
	 && strcasecmp(ausgabe,"+CME ERROR: INVALID INDEX")) {
        //use only token 1,2 and 4, write tokens 1 and 2 as-is
        //1st token
	token=(char *)strtok(&ausgabe[7],",");
	//anlysing token number and write all empty string to file, too
	if (atoi(token)!=current_entry) {
	    for (i=current_entry;i<atoi(token);i++) {
		sprintf(temp,"%d,\"\",\"\"\n",i);
		if (strlen(file)) {
		    if (write(myfd,temp,strlen(temp))!=strlen(temp)) {
			close(myfd);
			errexit("\nERROR on writing to %s.\n",file);
		    }
		}
		if (strcmp(file,"-")) {
		    myprintf(0," (%d)",i);
		}
	    }
	    current_entry=atoi(token);
	}
	if (strlen(file)) {
	    if ((write(myfd,token,strlen(token))!=strlen(token))
		  ||(write(myfd,",",1)!=1)){
		close(myfd);
		errexit("\nERROR on writing to %s.\n",file);			
	    }
	}
	if (strcmp(file,"-")) {
	    myprintf(0," %s",token);
	}

	//2nd token
	token=(char *)strtok(NULL,",");
	if (strlen(file)) {
	    if ((write(myfd,token,strlen(token))!=strlen(token))
		  ||(write(myfd,",",1)!=1)){
		close(myfd);
		errexit("\nERROR on writing to %s.\n",file);			
	    }
	}

	//3rd token, not saved, has to be recontructed on writing to phone
	strtok(NULL,",");

	//4th token, the description string may contain , and "
	token=(char *)strtok(NULL,"");
	//character conversion on token 4
	gsm2iso(token);
	//write converted token 4, also write a newline to make the file readable
	if (strlen(file)) {
	    if ((write(myfd,token,strlen(token))!=strlen(token))
		  ||(write(myfd,"\n",1)!=1)){
		close(myfd);
		errexit("\nERROR on writing to %s.\n",file);			
	    }
	}
				
	//reading next entry
	memset(ausgabe,0,sizeof(ausgabe));
	read_mytty(at_command,ausgabe);
	current_entry++;
    }
    for (i=current_entry;i<=last_entry;i++) {
	sprintf(temp,"%d,\"\",\"\"\n",i);
	if (strlen(file)) {
	    if (write(myfd,temp,strlen(temp))!=strlen(temp)) {
		close(myfd);
		errexit("\nERROR on writing to %s.\n",file);			
	    }
	}
	if (strcmp(file,"-")) {
	    myprintf(0," (%d)",i);
	}
    }
    close(myfd);
    myprintf(0,"\n");
    if (!strcmp(ausgabe,"OK")
	  ||!strcasecmp(ausgabe,"+CME ERROR: INVALID INDEX")){
	myprintf(0,"Received all gettable entries\n");
    } else if(!strcmp(ausgabe,"ERROR")) {
        errexit("An ERROR occured. Possible data corruption!\n");
    }
}
