/***************************************************************************
                          common.h  -  description
                             -------------------
    copyright            : (C) 2001 by Hendrik Sattler
    email                : post@hendrik-sattler.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//this file shall be an include for all subfiles of this project.

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <termios.h>
#include <getopt.h>
#include <time.h>
#include <sys/ioctl.h>
#include <string.h>
#include <signal.h>
#include <ctype.h>

#include "config.h"

//global variables
int mytty;
int VERBOSE_LEVEL;
char PIN[13];
int use_greek_chars;

//some own types
struct datapair {
    char* text;
    char* number;
};

/*
 * A bitfield for the settings
 * bits 3,2,1,0 -> file type
 *	x x x 1    file transfer
 *			0 0 0 1   bitmap
 *			0 0 1 1   midi
 *			0 1 0 1   vcs (vCalendar)
 *			0 1 1 1   vcf (vCard)
 *			1 x x 1   reserved for future use
 *	x x x 0    other types
 *			0 0 0 0   SMS (Short Message Service)
 *			0 0 1 0   phone book
 *			0 1 x 0   reserved
 *			1 x x 0   reserved
 * bits 7,6,5,4 -> action type
 *	x x x 1   direct mode
 *	x x 1 x   delete/remove
 *	x 1 x x   send
 *	1 x x x   get
 */

//functon declaration
//from scmxx.c (no direct text output anywhere else!!!)
void help(char *me);
void version();
void errexit(char *errmessage, ...);
void myprintf(int verbose_level, char *output, ...);
//from common.c
void set_ttyport(char* ttyport, char *newttyport);
speed_t ttyspeed(char *newttyspeed);
void new_at_command(char *at_command_p, char *addon_p);
void add_at_command(char *at_command_p, char *addon_p,...);
void com_mytty(char *at_command_p, char *ack_p);
void write_mytty(char *at_command_p);
void read_mytty(char *at_command_p, char *ausgabe_p);
void read_mytty_limited(char *at_command_p, char *ausgabe_p, int maxreadin);
void open_mytty(char* ttyport, speed_t baudrate);
void close_mytty();
int open_myFile_ro(char* file);
int open_myFile_rw(char* file);
void close_myFile(int filedes);
void deviceOpenFailed(int alarmtype);
void noAnswerFromPhone(int alarmtype);
//from numhandle.c
unsigned int hexstr2int(char *hexstring);
int is_number (char* string);
int is_pnumber (char* string, unsigned short positive_only);
//from action.c
void set_smsc(char* smsnr);
void set_time();
char* get_value(char* at);
char* get_vendor();
char* get_model();
char* get_revision();
char* get_phoneserial();
char* get_simserial();
char* get_simid();
char* get_operator();
char* get_smsc();
char* get_charset();
char* get_battery();
char* get_signal_ber();
char* get_time();
char* get_filetypes();
char* get_pbtypes();
void info();
//from s35.c
void handle_s35(char* file, char* pipe,
		int settings, int slot,
		struct datapair mydata, int flashsms,
		char* phonebook);
//from s35_files.c
void transfer_s35(int action, char* file, char *ftype,
		  int slot, int minimum, int maximum,
		  char* myPIPE);
void delete_file_s35(char *ftype, int slot);
int detect_free_s35(char *ftype, int minimum, int maximum);
void send_file_s35(char* file, char *ftype, int slot);
void get_file_s35(char* file, char *ftype, int slot, char* pipe);
//from s35_pbook.c
void pbook_s35(int action, char* file, char* phonebook);
void delete_pb_s35(char* phonebook);
void send_pb_s35(char* file, char* phonebook);
void get_pb_s35(char* file, char* phonebook);
//from s35_sms.c
void sms_s35(int action, char* file, char* pipe,
	     struct datapair mydata, int smsslot, int flashsms);
void delete_sms_s35(int smsslot);
void send_smsslot_s35(char* file, int smsslot, char* smsnumber);
void send_sms_s35(char* file, char* smstext, char* smsnumber, int direct, int flashsms);
void get_sms_s35(char* file, char* pipe, int smsslot);
void get_direct_sms_s35(char* file, char* pipe);
//from smspdu.c
void create_smssubmit_pdu(char *pdu, char* smstext, char* smsnumber,int flash);
void decode_smsdeliver_pdu(unsigned char* pdu, int status);
//from gsmcodes.c
void gsm2iso(unsigned char *token);
void iso2gsm(unsigned char *token);
void mask_pbook_chars(unsigned char *token);
int iso2gsm_sms(unsigned char *token);
void gsm2iso_sms(unsigned int length, unsigned char *token);

