/***************************************************************************
                          common.c  -  description
                             -------------------
    copyright            : (C) 2001 by Hendrik Sattler
    email                : post@hendrik-sattler.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"

//local to this file, retry number of ATZ
int RETRY_ATZ=0;

speed_t ttyspeed(char *newttyspeed){
    switch(atoi(newttyspeed)){
	case 9600:
		    return B9600;
		    break;
	case 19200:
		    return B19200;
		    break;
	case 38400:
		    return B38400;
		    break;
#ifdef B57600
	case 57600:
		    return B57600;
		    break;
#endif
#ifdef B115200
	case 115200:
		    return B115200;
		    break;
#endif
	default:
		    myprintf(0,"No valid baudrate defined. Using compiled in value...\n");
		    return ttyspeed(TTYSPEED);
		    break;
       }
}


void new_at_command(char *at_command_p, char *addon_p){
    memset(at_command_p,0,strlen(at_command_p));
    strcpy(&at_command_p[0],"AT");
    add_at_command(at_command_p,addon_p);
}

void add_at_command(char *at_command_p, char *addon_p,...){
    va_list arg_list;
    va_start(arg_list,addon_p);
    vsprintf(&at_command_p[strlen(at_command_p)],addon_p,arg_list);
    va_end(arg_list);
    myprintf(1,"Current set AT command: %s\n",at_command_p);
}

void open_mytty(char* ttyport, speed_t baudrate){
	int flags=O_RDWR | O_NOCTTY;
	struct termios newtio;

	//opening the device
	myprintf(0,"Accessing device %s\n",ttyport);
	
	signal(SIGALRM,deviceOpenFailed);
	alarm(10);
	mytty=open(ttyport,flags);
	if (mytty == -1){
		fprintf(stderr,"Error on opening device.\n");
		exit(1);
	}
	
	//setting port parameters
	if (tcgetattr(mytty,&newtio) < 0){
		fprintf(stderr,"Error in getting device attributes.\n");
		exit(1);
	}
	cfsetispeed(&newtio, baudrate); //input at baudrate
	cfsetospeed(&newtio, baudrate); //ouput at baudrate
	cfmakeraw(&newtio); //make raw, 8N1
	newtio.c_cc[VMIN]=0; // be comfortable with returning nothing on read
	newtio.c_cc[VTIME]=1; // try reading for this amount of time
	//newtio.c_lflag |= ICANON; //switch from raw to canonical
	tcflush(mytty, TCIOFLUSH); //clear serial tty
	if(tcsetattr(mytty,TCSANOW,&newtio) < 0){ //set now
		fprintf(stderr,"Error in setting device attributes.\n");
		exit(1);
	}
	alarm(0);
}

void com_mytty(char *at_command_p, char *ack_p){
	//write to the port...
	write_mytty(at_command_p);
	myprintf(1,"Command sent, awaiting answer from phone...\n");
	//...and read it to get the acknowledge or data
	read_mytty(at_command_p,ack_p);
}

void write_mytty(char *at_command_p){
	//Writing to the device
	myprintf(1,"\nSending: %s\n",at_command_p);
	//you have to finish with \r or no answer will ever come
	if (((write(mytty,at_command_p,strlen(at_command_p))) != strlen(at_command_p))
			 || ((write(mytty,"\r",1)) != 1)){
		errexit("Error on sending at command: %s\n",strerror(errno));
	}
}

void read_mytty (char *at_command_p, char *ausgabe_p){	
    read_mytty_limited (at_command_p, ausgabe_p, BUFSIZ-1);
}	

void read_mytty_limited (char *at_command_p, char *ausgabe_p, int maxreadin){	
    int status;
    char tempanswer[maxreadin+1];
    char tempat[BUFSIZ];
    char buffer;
    int counter;
    /*
     * Reading from the device
     * This really is not a pretty way but the only way to do it.
     * I tried to make it as clean as possible, though.
     * The main reason it has to be done this way: phonebook chars are not masked :-((
     */
    memset(ausgabe_p,0,strlen(ausgabe_p));
    do {
	counter=0;
	memset(tempanswer,0,sizeof(tempanswer));
	do {
	    status=read(mytty,&buffer,1);
	    //fix the @=0x00 problem here :-(
	    if (status && buffer==0) {
		/*
		 * we simply add the eigth bit, so when processing:
		 * only look at the last 7 bits (char&127)
	         */
		tempanswer[counter]=128;
	        counter++;
	    //we don't want values 10=<CR> and 13=<LF> in our strings
	    } else if (status && buffer!='\n' && buffer!='\r') {
	        tempanswer[counter]=buffer;
	        counter++;
	    }
	} while ((buffer!='\n' && counter<sizeof(tempanswer)-1) || counter==0);
	myprintf(1,"Received: %s\n",tempanswer);

	//PIN handling for all function is done transparently here
	if (!strncmp(tempanswer,"+CME ERROR: ",12)
	      && (strstr(tempanswer,"PIN")!=NULL
		  || strstr(tempanswer,"PIN")!=NULL)) {
	    if (strlen(PIN)==0) {
		errexit("%s\nUse the --pin parameter\n",&tempanswer[12]);
	    } else {
		memset(tempat,0,sizeof(tempat));
		new_at_command(tempat,"+CPIN");
		add_at_command(tempat,"=\"%s\"",PIN);
		memset(tempanswer,0,sizeof(tempanswer));
		com_mytty(tempat,tempanswer);
		if (strcmp(tempanswer,"OK")) {
		    errexit("Error on using pin: %s\n",&tempanswer[12]);
		}
		memset(tempanswer,0,sizeof(tempanswer));
	        com_mytty(at_command_p,tempanswer);
	    }
	}
    //we do not accept the at_command as answer
    } while (!strcmp(tempanswer,at_command_p));
    strcpy(ausgabe_p,tempanswer);
}

void close_mytty(){
    close(mytty);
}

int open_myFile_ro (char* file) {
    int myfd;
	
    if (strlen(file) && strcmp(file,"-")) {
	myfd=open(file,O_RDONLY);
	if (myfd==-1) {
	    errexit("Could not access %s, aborting\n",file);
	}
	myprintf(0,"Accessing %s\n",file);
    } else {
	myfd=0;
	myprintf(0,"Accessing stdin\n");
    }
    if (isatty(myfd)) {
        myprintf(0,"Please input the data and finish with Ctrl-D on an empty line:\n");
    }
    return(myfd);
}

int open_myFile_rw(char* file){
    int myfd;

    if (strlen(file) && strcmp(file,"-")) {
	myfd=open(file ,O_RDWR|O_CREAT|O_EXCL, S_IRUSR|S_IWUSR|S_IRGRP);
	if (myfd==-1){
	    close(myfd);
	    errexit("%s could not be created.\n",file);
	} else {
	    myprintf(0,"%s created.\n",file);
	}
    }else{
	myfd=1;
    }
    return(myfd);
}

void close_myFile (int filedes) {
    if (filedes > 2) {
	close(filedes);
    }
}

void deviceOpenFailed(int alarmtype){
    errexit("Timeout on opening device.\n");
}

void noAnswerFromPhone(int alarmtype){
    RETRY_ATZ++;
    if (RETRY_ATZ < 3) {
	myprintf(0,"Waiting for an answer from the phone: Timed out. Retrying...\n");
	alarm(10);
	tcflush(mytty, TCIFLUSH);
	write_mytty("ATZ");
    } else {
        errexit("Waiting for an answer from the phone: Timed out. Aborting.\n");
    }
}
