/*  Sclient
 *  Copyright (C) 1999 Heathen (the.heathen@swipnet.se)
 *		  1999 Drizzt  (doc.day@swipnet.se)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <stdio.h>
#include <string.h>

#include "ansi.h"

/* from bezerk */
gushort convert_color (unsigned c)
{
    if ( c == 0 )
        return 0;
    c *= 257;

    return (c > 0xffff) ? 0xffff : c;
}

/* from bezerk */
void extract_color (GdkColor *color, unsigned red, unsigned green, unsigned blue)
{
    color->red   = convert_color (red);
    color->green = convert_color (green);
    color->blue  = convert_color (blue);
}

/* from bezerk */
void init_colors ()
{
    
    cmap = gdk_colormap_get_system ();
    
    extract_color(&color_lightwhite, 254, 254, 254);
    if (!gdk_color_alloc(cmap, &color_lightwhite)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_white, 191, 191, 191);
    if (!gdk_color_alloc(cmap, &color_white)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_lightblue, 0, 0, 255);
    if (!gdk_color_alloc(cmap, &color_lightblue)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_blue, 0, 0, 127);
    if (!gdk_color_alloc(cmap, &color_blue)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_lightgreen, 0, 255, 0);
    if (!gdk_color_alloc(cmap, &color_lightgreen)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_green, 0, 127, 0);
    if (!gdk_color_alloc(cmap, &color_green)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_lightred, 255, 0, 0);
    if (!gdk_color_alloc(cmap, &color_lightred)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_red, 127, 0, 0);
    if (!gdk_color_alloc(cmap, &color_red)) {
        g_error("couldn't allocate color");
    }
   extract_color(&color_lightyellow, 255, 255, 0);
    if (!gdk_color_alloc(cmap, &color_lightyellow)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_yellow, 127, 127, 0);
    if (!gdk_color_alloc(cmap, &color_yellow)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_lightmagenta, 255, 0, 255);
    if (!gdk_color_alloc(cmap, &color_lightmagenta)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_magenta, 127, 0, 127);
    if (!gdk_color_alloc(cmap, &color_magenta)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_lightcyan, 0, 255, 255);
    if (!gdk_color_alloc(cmap, &color_lightcyan)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_cyan, 0, 127, 127);
    if (!gdk_color_alloc(cmap, &color_cyan)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_lightblack, 127, 127, 127);
    if (!gdk_color_alloc(cmap, &color_lightblack)) {
        g_error("couldn't allocate color");
    }
    extract_color(&color_black, 0, 0, 0);
    if (!gdk_color_alloc(cmap, &color_black)) {
        g_error("couldn't allocate color");
    }

    default_color_white 		= color_white;
    default_color_lightwhite 	= color_lightwhite;
    default_color_blue 		= color_blue;		//default_color_white 	= color_white;
    default_color_lightblue 	= color_lightblue;	//default_color_white 	= color_white;
    default_color_green 		= color_green;		//default_color_white 	= color_white;
    default_color_lightgreen 	= color_lightgreen;	//default_color_white 	= color_white;
    default_color_red	 	= color_red;		//default_color_white 	= color_white;
    default_color_lightred 		= color_lightred;		//default_color_white 	= color_white;
    default_color_yellow 		= color_yellow;		//default_color_white 	= color_white;
    default_color_lightyellow 	= color_lightyellow;	//default_color_white 	= color_white;
    default_color_magenta 	= color_magenta;	//default_color_white 	= color_white;
    default_color_lightmagenta 	= color_lightmagenta;	//default_color_white 	= color_white;
    default_color_cyan	 	= color_cyan;		//default_color_white 	= color_white;
    default_color_lightcyan 	= color_lightcyan;	//default_color_white 	= color_white;
    default_color_black 		= color_black;		//default_color_white 	= color_white;
    default_color_lightblack 	= color_lightblack;	//default_color_white 	= color_white;

    /* Hmm, why is this here??? CHECK IT OUT */
    if ( !font.FontName )
        font.FontName = g_strdup ("fixed");
    if ( ( font_normal = gdk_font_load (font.FontName) ) == NULL )
    {
        g_error ("Can't load font... Using default.\n");
        g_free ( font.FontName );
        font.FontName = g_strdup ("fixed");
        save_font ();
    }
}

void test_getcol(char *tmp, int bleh){

   int BOLD = FALSE;
    switch(bleh){

        case 2: if(!strncmp(tmp,"[0m",2) || !strncmp(tmp,"[m",2)) {
                    fg_col = prefs.DefaultColor; 
                    return;
                } 
		break;
	case 3: if(!strncmp(tmp,"[0m",3)) {
                    fg_col = prefs.DefaultColor;
		    return;
                }
                if(!strncmp(tmp,"[1m",3)) {
		    fg_col = color_lightwhite;
		    return;
		}
		break;
	case 4:
		if(!strncmp(tmp,"[30m",4)) {
		    fg_col = color_black;
		    return;
		}
		if(!strncmp(tmp,"[31m",4)) {
		    fg_col = color_red;
		    return;
		}
		if(!strncmp(tmp,"[32m",4)) {
		    fg_col = color_green;
		    return;
		}
		if(!strncmp(tmp,"[33m",4)) {
		    fg_col = color_yellow;
		    return;
		}
		if(!strncmp(tmp,"[34m",4)) {
		    fg_col = color_blue;
		    return;
		}
		if(!strncmp(tmp,"[35m",4)) {
		    fg_col = color_magenta;
		    return;
		}
		if(!strncmp(tmp,"[36m",4)) {
		    fg_col = color_cyan;
		    return;
		}
		if(!strncmp(tmp,"[37m",4)) {
		    fg_col = color_white;
		    return;
		}
		if(!strncmp(tmp,"[40m",4)) {
		    bg_col = prefs.BackgroundColor; /* set background to user specified color!???! */
		    return;			    /* not sure if this is right??		   */
		}
		if(!strncmp(tmp,"[41m",4)) {
		    bg_col = color_red;
		    return;
		}
		if(!strncmp(tmp,"[42m",4)) {
		    bg_col = color_green;
		    return;
		}
		if(!strncmp(tmp,"[43m",4)) {
		    bg_col = color_yellow;
		    return;
		}
		if(!strncmp(tmp,"[44m",4)) {
		    bg_col = color_blue;
		    return;
		}
		if(!strncmp(tmp,"[45m",4)) {
		    bg_col = color_magenta;
		    return;
		}
		if(!strncmp(tmp,"[46m",4)) {
		    bg_col = color_cyan;
		    return;
		}
		if(!strncmp(tmp,"[47m",4)) {
		    bg_col = color_white;
		    return;
		}
		break;
	case 6:
		if(!strncmp(tmp,"[0;30m",6)) {
		    fg_col = color_black;
		    return;
		}
		if(!strncmp(tmp,"[0;31m",6)) {
		    fg_col = color_red;
		    return;
		}
		if(!strncmp(tmp,"[0;32m",6)) {
		    fg_col = color_green;
		    return;
		}
		if(!strncmp(tmp,"[0;33m",6)) {
		    fg_col = color_yellow;
		    return;
		}
		if(!strncmp(tmp,"[0;34m",6)) {
		    fg_col = color_blue;
		    return;
		}
		if(!strncmp(tmp,"[0;35m",6)) {
		    fg_col = color_magenta;
		    return;
		}
		if(!strncmp(tmp,"[0;36m",6)) {
		    fg_col = color_cyan;
		    return;
		}
		if(!strncmp(tmp,"[0;37m",6)) {		/* Escape sequence [0;37m */
		    fg_col = color_white;	        		/* reset color to white!! */
                    	   bg_col = prefs.BackgroundColor;	/* reset background to user specified Color! */
		    return;
		}
		if(!strncmp(tmp,"[1;30m",6)) {
		    fg_col = color_lightblack;
		    return;
		}
		if(!strncmp(tmp,"[1;31m",6)) {
		    fg_col = color_lightred;
		    return;
		}
		if(!strncmp(tmp,"[1;32m",6)) {
		    fg_col = color_lightgreen;
		    return;
		}
		if(!strncmp(tmp,"[1;33m",6)) {
		    fg_col = color_lightyellow;
		    return;
		}
		if(!strncmp(tmp,"[1;34m",6)) {
		    fg_col = color_lightblue;
		    return;
		}
		if(!strncmp(tmp,"[1;35m",6)) {
		    fg_col = color_lightmagenta;
		    return;
		}
		if(!strncmp(tmp,"[1;36m",6)) {
		    fg_col = color_lightcyan;
		    return;
		}
		if(!strncmp(tmp,"[1;37m",6)) {
		    fg_col = color_lightwhite;
		    return;
		}
		if(!strncmp(tmp,"[1;40m",6)) {
		    bg_col = color_lightblack;
		    return;
		}
		if(!strncmp(tmp,"[1;41m",6)) {
		    bg_col = color_lightred;
		    return;
		}
		if(!strncmp(tmp,"[1;42m",6)) {
		    bg_col = color_lightgreen;
		    return;
		}
		if(!strncmp(tmp,"[1;43m",6)) {
		    bg_col = color_lightyellow;
		    return;
		}
		if(!strncmp(tmp,"[1;44m",6)) {
		    bg_col = color_lightblue;
		    return;
		}
		if(!strncmp(tmp,"[1;45m",6)) {
		    bg_col = color_lightmagenta;
		    return;
		}
		if(!strncmp(tmp,"[1;46m",6)) {
		    bg_col = color_lightcyan;
		    return;
		}
		if(!strncmp(tmp,"[1;47m",6)) {
		    bg_col = color_lightwhite;
		    return;
		}
		if(!strncmp(tmp,"[0;40m",6)) {
		    bg_col = color_black;
		    return;
		}
		if(!strncmp(tmp,"[0;41m",6)) {
		    bg_col = color_red;
		    return;
		}
		if(!strncmp(tmp,"[0;42m",6)) {
		    bg_col = color_green;
		    return;
		}
		if(!strncmp(tmp,"[0;43m",6)) {
		    bg_col = color_yellow;
		    return;
		}
		if(!strncmp(tmp,"[0;44m",6)) {
		    bg_col = color_blue;
		    return;
		}
		if(!strncmp(tmp,"[0;45m",6)) {
		    bg_col = color_magenta;
		    return;
		}
		if(!strncmp(tmp,"[0;46m",6)) {
		    bg_col = color_cyan;
		    return;
		}
		if(!strncmp(tmp,"[0;47m",6)) {
		    bg_col = color_white;
		    return;
		}
		if(!strncmp(tmp,"[J",2)) {
		    fg_col = color_lightwhite;
		    return;
		}
		break;
	case 8:
		if(!strncmp(tmp,"[0;1;30m",8)) {
		    fg_col = color_lightblack;
		    return;
		}
		if(!strncmp(tmp,"[0;1;31m",8)) {
		    fg_col = color_lightred;
		    return;
		}
		if(!strncmp(tmp,"[0;1;32m",8)) {
		    fg_col = color_lightgreen;
		    return;
		}
		if(!strncmp(tmp,"[0;1;33m",8)) {
		    fg_col = color_lightyellow;
		    return;
		}
		if(!strncmp(tmp,"[0;1;34m",8)) {
		    fg_col = color_lightblue;
		    return;
		}
		if(!strncmp(tmp,"[0;1;35m",8)) {
		    fg_col = color_lightmagenta;
		    return;
		}
		if(!strncmp(tmp,"[0;1;36m",8)) {
		    fg_col = color_lightcyan;
		    return;
		}
		if(!strncmp(tmp,"[0;1;37m",8)) {
		    fg_col = color_lightwhite;
		    return;
		}
		if(!strncmp(tmp,"[0;0;30m",8)) {
		    fg_col = color_black;
		    return;
		}
		if(!strncmp(tmp,"[0;0;31m",8)) {
		    fg_col = color_red;
		    return;
		}
		if(!strncmp(tmp,"[0;0;32m",8)) {
		    fg_col = color_green;
		    return;
		}
		if(!strncmp(tmp,"[0;0;33m",8)) {
		    fg_col = color_yellow;
		    return;
		}
		if(!strncmp(tmp,"[0;0;34m",8)) {
		    fg_col = color_blue;
		    return;
		}
		if(!strncmp(tmp,"[0;0;35m",8)) {
		    fg_col = color_magenta;
		    return;
		}
		if(!strncmp(tmp,"[0;0;36m",8)) {
		    fg_col = color_cyan;
		    return;
		}
		if(!strncmp(tmp,"[0;0;37m",8)) {
		    fg_col = color_white;
		    return;
		}
		if(!strncmp(tmp,"[0;5;30m",8)) {
		    fg_col = color_lightblack;
		    return;
		}
		if(!strncmp(tmp,"[0;5;31m",8)) {
		    fg_col = color_lightred;
		    return;
		}
		if(!strncmp(tmp,"[0;5;32m",8)) {
		    fg_col = color_lightgreen;
		    return;
		}
		if(!strncmp(tmp,"[0;5;33m",8)) {
		    fg_col = color_lightyellow;
		    return;
		}
		if(!strncmp(tmp,"[0;5;34m",8)) {
		    fg_col = color_lightblue;
		    return;
		}
		if(!strncmp(tmp,"[0;5;35m",8)) {
		    fg_col = color_lightmagenta;
		    return;
		}
		if(!strncmp(tmp,"[0;5;36m",8)) {
		    fg_col = color_lightcyan;
		    return;
		}
		if(!strncmp(tmp,"[0;5;37m",8)) {
		    fg_col = color_lightwhite;
		    return;
		}
		break;
        case 9:
                if(!strncmp(tmp, "[0;", 3)) {
                    BOLD = FALSE;
                } else {
                    BOLD= TRUE;
                }
                if (tmp[3] == '4') {
                    switch (tmp[4]) {
                        case '0':
                                  bg_col = color_black;
                                  break;
                        case '1':
                                  bg_col = color_lightred;
                                  break;
                        case '2':
                                  bg_col = color_lightgreen;
                                  break;
                        case '3':
                                  bg_col = color_lightyellow;
                                  break;
                        case '4':
                                  bg_col = color_lightblue;
                                  break;
                        case '5':
                                  bg_col = color_lightmagenta;
                                  break;
                        case '6':
                                  bg_col = color_lightcyan;
                                  break;
                        case '7':
                                  bg_col = color_lightwhite;
                                  break;
                        default:
                                 bg_col = prefs.BackgroundColor;
                    }
                }
                if (tmp[6] == '3') {
                    switch (tmp[7]) {
                        case '0':
                                  if (BOLD)
                                      fg_col = color_lightblack;
                                  else
                                      fg_col = color_black;
                                  break;
                        case '1':
                                  if (BOLD)
                                      fg_col = color_lightred;
                                  else
                                      fg_col = color_red;
                                  break;
                        case '2':
                                  if (BOLD)
                                      fg_col = color_lightgreen;
                                  else
                                      fg_col = color_green;
                                  break;
                        case '3':
                                  if (BOLD)
                                      fg_col = color_lightyellow;
                                  else
                                      fg_col = color_yellow;
                                  break;
                        case '4':
                                  if (BOLD)
                                      fg_col = color_lightblue;
                                  else
                                      fg_col = color_blue;
                                  break;
                        case '5':
                                  if (BOLD)
                                      fg_col = color_lightmagenta;
                                  else
                                      fg_col = color_magenta;
                                  break;
                        case '6':
                                  if (BOLD)
                                      fg_col = color_lightcyan;
                                  else
                                      fg_col = color_cyan;
                                  break;
                        case '7':
                                  if (BOLD)
                                      fg_col = color_lightwhite;
                                  else
                                      fg_col = color_white;
                                  break;
                        default:
                                 fg_col = prefs.DefaultColor;
                                 return;
                    }
                    return;
                }
		break;

	default:
		fg_col = prefs.DefaultColor;
                return;
    }
    fg_col = prefs.DefaultColor;
    return;
}

void disp_ansi(int size, gchar *in, GtkWidget *target){
	int n=0,x=0;
        fg_col=prefs.DefaultColor;
        bg_col=prefs.BackgroundColor;

	gtk_text_freeze(GTK_TEXT(target));

	while(n < size) {

		/* stripp out goofy signs like linefeeds.... */
		if(in[n] == '\x0d')
		  n++;

		/* mask the password at login */
		if(in[n] == -1 && in[n+2] == 1) {
		  if(in[n+1] == -5)
		    GTK_ENTRY(mud->ent)->visible = 0;
		  if(in[n+1] == -4)
		    GTK_ENTRY(mud->ent)->visible = 1;
		  n+=3;
		}

                    /* we have intercepted the beep character */
                    if (in[n] =='\a') {
                        /* are we going to send out the beep? */
                        if (prefs.DoBeep)
                           gdk_beep();
                        n++;
                     }

			/* plain text no color nothing */
		if(in[n] != 27) {
                    if (mud->LOGGING) /* Loging */
                        fputc(in[n], mud->LOG_FILE);
		    gtk_text_insert(GTK_TEXT(target), font_normal, &fg_col, &bg_col, &in[n], 1);
		    gtk_text_insert (GTK_TEXT (target), NULL, NULL, NULL," ", 1 );
		    gtk_text_backward_delete (GTK_TEXT (target), 1);
		}
			/* color and special signs -> stripp it! */
		else {
		  while(in[x+n] != 'm')
		      x++;
		  if(x <= 9)
                    test_getcol(&in[n+1], x);
		  n += x;
		  x = 0;
		}
		n++;
	}			
	gtk_text_thaw(GTK_TEXT(target));
	return;
}

