/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Clément DAVID
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

package org.scilab.modules.xcos.block;

/**
 * Class defined for compatibility issues.
 * 
 * All the logic is now on {@link PrintBlock}.
 */
public final class ConstBlock extends PrintBlock {
	/**
	 * Default constructor
	 */
	public ConstBlock() {
		super();
	}
	
	/**
	 * Set the default block name.
	 */
	@Override
	protected void setDefaultValues() {
		super.setDefaultValues();
		setInterfaceFunctionName("CONST_m");
		setSimulationFunctionName("cstblk4");
		setValue("1");
	}
}
