//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function action = CL__menu(id)
// Menu CelestLab

// Declarations:


// Code:

  rhs = argn(2);

  if rhs <> 1 then
    CL__error(msprintf(gettext("%s: Wrong number of input argument: %d expected.\n"),"CL__menu",1));
  end

  if id == 1 then
    action = "CL__demos();";
  elseif id == 2 then
    action = "global %helps;helpbrowser(%helps(:,1), ""CelestLab"", getlanguage(), %t);helpbrowser(%helps(:,1), ""CelestLab"", getlanguage(), %f);";
  elseif id == 3 then
    action = "CL__releaseNotes();";
  else
    action = "";
  end

endfunction
