      SUBROUTINE PBCTRAD1( ICONTXT, UPLO, FORM, M, N, NZ, ALPHA, A, LDA,
     $                     BETA, B, LDB, MINT, NINT, MEN, NEN )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     .. Scalar Arguments ..
      CHARACTER          FORM, UPLO
      INTEGER            ICONTXT, LDA, LDB, M, MEN, MINT, N, NEN, NINT,
     $                   NZ
      COMPLEX            ALPHA, BETA
*     ..
*     .. Array Arguments ..
      COMPLEX            A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  PBCTRAD1 copies part of an upper (or lower) triangular matrix A
*  to another matrix B:
*                       B <== alpha * A + beta * B
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, J, JP, JX, KZ, MM, MX
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      EXTERNAL           ICEIL, LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           PBCMATADD, PBCVECADD
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN, REAL
*     ..
*     .. Executable Statements ..
*
      IF( LSAME( UPLO, 'U' ) ) THEN
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is upper triangular (triangular part is at the bottom)
*
            MM = M
            JP = 0
            DO 10 J = 1, MIN( N-NZ, NEN-JP )
               JX = JP + J
               CALL PBCVECADD( ICONTXT, 'G', MM+J, ALPHA, A( 1, JX ), 1,
     $                         BETA, B( 1, JX ), 1 )
   10       CONTINUE
            MM = MM + MINT - NZ
            JP = JP + NINT - NZ
*
            DO 30 I = 2, ICEIL( NEN+NZ, NINT )
               DO 20 J = 1, MIN( N, NEN-JP )
                  JX = JP + J
                  CALL PBCVECADD( ICONTXT, 'G', MM+J, ALPHA, A( 1, JX ),
     $                            1, BETA, B( 1, JX ), 1 )
   20          CONTINUE
               MM = MM + MINT
               JP = JP + NINT
   30       CONTINUE
*
         ELSE IF( LSAME( FORM, 'H' ) ) THEN
*
*           A is upper triangular Hermitian
*
            MM = M
            JP = 0
            DO 40 J = 1, MIN( N-NZ, NEN-JP )
               JX = JP + J
               B( MM+J, JX ) = REAL( BETA ) * REAL( B( MM+J, JX ) ) +
     $                         REAL( ALPHA ) * REAL( A( MM+J, JX ) )
               CALL PBCVECADD( ICONTXT, 'G', MM+J-1, ALPHA, A( 1, JX ),
     $                         1, BETA, B( 1, JX ), 1 )
   40       CONTINUE
            MM = MM + MINT - NZ
            JP = JP + NINT - NZ
*
            DO 60 I = 2, ICEIL( NEN+NZ, NINT )
               DO 50 J = 1, MIN( N, NEN-JP )
                  JX = JP + J
                  B( MM+J, JX ) = REAL( BETA ) * REAL( B( MM+J, JX ) ) +
     $                            REAL( ALPHA ) * REAL( A( MM+J, JX ) )
                  CALL PBCVECADD( ICONTXT, 'G', MM+J-1, ALPHA,
     $                            A( 1, JX ), 1, BETA, B( 1, JX ), 1 )
   50          CONTINUE
               MM = MM + MINT
               JP = JP + NINT
   60       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            MM = M
            JP = 1
            KZ = NZ
            DO 70 I = 1, ICEIL( NEN+NZ, NINT )
               CALL PBCMATADD( ICONTXT, 'G', MM, MIN( N-KZ, NEN-JP+1 ),
     $                         ALPHA, A( 1, JP ), LDA, BETA, B( 1,JP ),
     $                         LDB )
               MM = MM + MINT
               JP = JP + NINT - KZ
               KZ = 0
   70       CONTINUE
*
         END IF
*
      ELSE
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is lower triangular (triangular part is at the top)
*
            MM = M
            JP = 0
            DO 80 J = 1, MIN( N-NZ, NEN-JP )
               MX = MM + J
               JX = JP + J
               IF( MX.LE.MEN )
     $            CALL PBCVECADD( ICONTXT, 'G', MEN-MX+1, ALPHA,
     $                            A( MX, JX ), 1, BETA, B( MX, JX ), 1 )
   80       CONTINUE
            MM = MM + MINT - NZ
            JP = JP + NINT - NZ
*
            DO 100 I = 2, ICEIL( NEN+NZ, NINT )
               DO 90 J = 1, MIN( N, NEN-JP )
                  MX = MM + J
                  JX = JP + J
                  IF( MX.LE.MEN )
     $               CALL PBCVECADD( ICONTXT, 'G', MEN-MX+1, ALPHA,
     $                               A( MX, JX ), 1, BETA, B( MX, JX ),
     $                               1 )
   90          CONTINUE
               MM = MM + MINT
               JP = JP + NINT
  100       CONTINUE
*
         ELSE IF( LSAME( FORM, 'H' ) ) THEN
*
*           A is lower triangular (triangular part is at the top)
*
            MM = M
            JP = 0
            DO 110 J = 1, MIN( N-NZ, NEN-JP )
               MX = MM + J
               JX = JP + J
               IF( MX.LE.MEN ) THEN
                  B( MX, JX ) = REAL( BETA ) * REAL( B( MX, JX ) ) +
     $                          REAL( ALPHA ) * REAL( A( MX, JX ) )
                  CALL PBCVECADD( ICONTXT, 'G', MEN-MX, ALPHA,
     $                            A( MX+1, JX ), 1, BETA, B( MX+1, JX ),
     $                            1 )
               END IF
  110       CONTINUE
            MM = MM + MINT - NZ
            JP = JP + NINT - NZ
*
            DO 130 I = 2, ICEIL( NEN+NZ, NINT )
               DO 120 J = 1, MIN( N, NEN-JP )
                  MX = MM + J
                  JX = JP + J
                  IF( MX.LE.MEN ) THEN
                     B( MX, JX ) = REAL( BETA )*REAL( B( MX, JX ) ) +
     $                          REAL( ALPHA )*REAL( A( MX, JX ) )
                     CALL PBCVECADD( ICONTXT, 'G', MEN-MX, ALPHA,
     $                               A( MX+1, JX ), 1, BETA,
     $                               B( MX+1, JX ), 1 )
                  END IF
  120          CONTINUE
               MM = MM + MINT
               JP = JP + NINT
  130       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            MM = M + 1
            JP = 1
            KZ = NZ
            DO 140 I = 1, ICEIL( NEN+NZ, NINT )
               CALL PBCMATADD( ICONTXT, 'G', MEN-MM+1,
     $                         MIN(N-KZ, NEN-JP+1), ALPHA, A( MM, JP ),
     $                         LDA, BETA, B( MM, JP ), LDB )
               MM = MM + MINT
               JP = JP + NINT - KZ
               KZ = 0
  140       CONTINUE
         END IF
      END IF
*
      RETURN
*
*     End of PBCTRAD1
*
      END
