#!/usr/bin/perl

use strict;

my $face = $ARGV[0];
my $srcenc = $ARGV[1];

sub transformfont {
    my $shape = shift;
    if (-f "${face}${shape}${srcenc}.afm") {
	print STDOUT "\\transformfont{${face}${shape}6r}{\\reencodefont{6r}{\\fromafm{${face}${shape}${srcenc}}}}\n";
    }
}

sub transformslfont {
    my $shape = shift;
    if (-f "${face}${shape}${srcenc}.afm" && ! -f "${face}${shape}o${srcenc}.afm") {
	print STDOUT "\\transformfont{${face}${shape}o6r}{\\slantfont{167}{\\frommtx{${face}${shape}6r}}}\n";
    }
}

print STDOUT <<'EOF';
\input fontinst.sty
\input fnstcorr
\input cyralias

\installfonts
\transformfont{psyro}{\slantfont{167}{\fromafm{psyr}}}
EOF

&transformfont ('r');
&transformfont ('ri');
&transformfont ('ro');
&transformfont ('b');
&transformfont ('bi');
&transformfont ('bo');
&transformslfont ('r');
&transformslfont ('b');

print STDOUT <<'EOF';
\endinstallfonts

\bye
EOF
