#!/usr/bin/perl

use strict;

my $face = $ARGV[0];
my $enc = $ARGV[1];

my $texenc;
for ($enc) {
    /OT1/ && do {$texenc = '7t';last;};
    /T1/ && do {$texenc = '8t';last;};
    /TS1/ && do {$texenc = '8c';last;};
    /OT2/ && do {$texenc = '7k';last;};
    /T2A/ && do {$texenc = '6a';last;};
    /T2B/ && do {$texenc = '6t';last;};
    /T2C/ && do {$texenc = '6c';last;};
    /X2/ && do {$texenc = '6x';last;};
}

my $lcenc = $enc;
$lcenc =~ tr/A-Z/a-z/;

my $ft;
for ($enc) {
    /OT1|T1/ && do {$ft = ",latin";last;};
    /TS1/ && do {$ft = ",textcomp";last;};
    /OT2|T2A|T2B|T2C|X2/ && do {$ft = ",latin,cyrillic";last;};
}

sub installfont {
    my ($shape, $arg) = @_;
    if (-f "${face}${shape}6r.mtx") {
	print STDOUT "\\installfont{${face}${shape}${texenc}}{${face}${shape}6r,psyr scaled 1100${ft}}{${lcenc}}{${enc}}{${face}}${arg}\n";
    }
}

sub installslfont {
    my ($shape, $arg) = @_;
    if (-f "${face}${shape}6r.mtx") {
	print STDOUT "\\installfont{${face}${shape}${texenc}}{${face}${shape}6r,psyro scaled 1100${ft}}{${lcenc}}{${enc}}{${face}}${arg}\n";
    }
}

sub installcapsfont {
    my ($shape, $arg) = @_;
    if (-f "${face}${shape}6r.mtx" && $enc ne 'TS1') {
	print STDOUT "\\installfont{${face}${shape}c${texenc}}{${face}${shape}6r,psyr scaled 1100${ft}}{${lcenc}c}{${enc}}{${face}}${arg}\n";
    }
}

print STDOUT <<'EOF';
\input fontinst.sty
\input fnstcorr
\input cyralias

\installfonts
EOF
printf STDOUT "\\installfamily{%s}{%s}{}\n", $enc, $face;
&installfont('r', '{m}{n}{}');
&installcapsfont('r', '{m}{sc}{}');
&installslfont('ro', '{m}{sl}{}');
&installslfont('ri', '{m}{it}{}');
&installfont('b', '{b}{n}{}');
&installcapsfont('b', '{b}{sc}{}');
&installslfont('bo', '{b}{sl}{}');
&installslfont('bi', '{b}{it}{}');

print STDOUT <<'EOF';
\endinstallfonts

\bye
EOF
