/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

public final class MethodAttributes {
    public static final short MemberAccessMask = 7;
    public static final short PrivateScope = 0;
    public static final short Private = 1;
    public static final short FamANDAssem = 2;
    public static final short Assembly = 3;
    public static final short Family = 4;
    public static final short FamORAssem = 5;
    public static final short Public = 6;
    public static final short Static = 16;
    public static final short Final = 32;
    public static final short Virtual = 64;
    public static final short HideBySig = 128;
    public static final short VtableLayoutMask = 256;
    public static final short ReuseSlot = 0;
    public static final short NewSlot = 256;
    public static final short Abstract = 1024;
    public static final short SpecialName = 2048;
    public static final short PInvokeImpl = 8192;
    public static final short UnmanagedExport = 8;
    public static final short RTSpecialName = 4096;
    public static final short HasSecurity = 64;
    public static final short RequireSecObject = 16384;
    public static final short ReservedMask = 0;

    public static String toString(short attrs) {
        StringBuffer str = new StringBuffer(MethodAttributes.accessFlagsToString(attrs));
        if ((attrs & 0x10) != 0) {
            str.append(" static");
        }
        if ((attrs & 0x20) != 0) {
            str.append(" final");
        }
        if ((attrs & 0x40) != 0) {
            str.append(" virtual");
        }
        if ((attrs & 0x400) != 0) {
            str.append(" abstract");
        }
        if ((attrs & 0x80) != 0) {
            str.append(" hidebysig");
        }
        if ((attrs & 0x100) != 0) {
            str.append(" newslot");
        }
        if ((attrs & 0x800) != 0) {
            str.append(" specialname");
        }
        if ((attrs & 0x2000) != 0) {
            str.append(" pinvokeimpl(?!?)");
        }
        if ((attrs & 0x1000) != 0) {
            str.append(" rtspecialname");
        }
        return str.toString();
    }

    public static String accessFlagsToString(short attrs) {
        switch (attrs & 7) {
            case 0: {
                return "compilercontrolled";
            }
            case 1: {
                return "private";
            }
            case 2: {
                return "famandassem";
            }
            case 3: {
                return "assembly";
            }
            case 4: {
                return "family";
            }
            case 5: {
                return "famorassem";
            }
            case 6: {
                return "public";
            }
        }
        return "xxx";
    }

    private MethodAttributes() {
    }
}

