/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Policy;

class PhonePolicy
extends Policy {
    int x;
    int y;
    int offset;
    int numChars;

    PhonePolicy(Font f) {
        super(f);
    }

    boolean validateContent(char[] buffer, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            char c = buffer[i];
            if ((c < '0' || c > '9') && c != '#' && c != '*' && c != '+') {
                return false;
            }
            ++i;
        }
        return true;
    }

    void paintBlock(Graphics g, char[] buf, int cursorPos, boolean cursorEnabled, int numCharsInBlock) {
        int neededSpace = 0;
        boolean xCurPos = false;
        int numCharsToPaint = this.numChars - this.offset;
        if (numCharsToPaint > numCharsInBlock) {
            numCharsToPaint = numCharsInBlock;
        }
        int clipY = g == null ? 3 * this.lineHeight : g.getClipY() + g.getClipHeight();
        if (numCharsToPaint > 0) {
            neededSpace = this.f.charsWidth(buf, this.offset, numCharsToPaint);
            if (this.x + neededSpace > this.width) {
                if (neededSpace <= this.width) {
                    this.y += this.lineHeight;
                    if (this.y + this.lineHeight > clipY) {
                        return;
                    }
                    this.x = 0;
                } else {
                    int numDigsOnLine = this.width / this.f.charWidth('9');
                    this.paintBlock(g, buf, cursorPos, cursorEnabled, numDigsOnLine);
                    this.paintBlock(g, buf, cursorPos, cursorEnabled, numCharsToPaint - numDigsOnLine);
                    return;
                }
            }
            if (g != null) {
                g.drawChars(buf, this.offset, numCharsToPaint, this.x, this.y, 20);
                if (cursorEnabled && (cursorPos > this.offset && cursorPos <= this.offset + numCharsToPaint || cursorPos == 0 && this.offset == 0)) {
                    this.cursorX = this.x + this.f.charsWidth(buf, this.offset, cursorPos - this.offset);
                    this.cursorY = this.y;
                    g.drawLine(this.cursorX, this.cursorY, this.cursorX, this.cursorY + this.lineHeight);
                }
            }
            this.x += neededSpace;
            if (numCharsToPaint == numCharsInBlock) {
                this.x += this.f.charWidth(' ');
            }
            this.offset += numCharsToPaint;
        }
    }

    void paint(Graphics g, char[] buf, int numChars, boolean cursorEnabled, int cursorPos, boolean noCharShow) {
        this.y = 0;
        this.x = 0;
        this.offset = 0;
        this.numChars = numChars;
        if (g != null) {
            g.setColor(0);
            g.setFont(this.f);
        }
        if (numChars > 0) {
            if (buf[0] == '0') {
                this.paintBlock(g, buf, cursorPos, cursorEnabled, 3);
                this.paintBlock(g, buf, cursorPos, cursorEnabled, 3);
                this.paintBlock(g, buf, cursorPos, cursorEnabled, numChars - this.offset);
            } else if (buf[0] == '1') {
                this.paintBlock(g, buf, cursorPos, cursorEnabled, 1);
                this.paintBlock(g, buf, cursorPos, cursorEnabled, 3);
                this.paintBlock(g, buf, cursorPos, cursorEnabled, 3);
                this.paintBlock(g, buf, cursorPos, cursorEnabled, numChars - this.offset);
            } else {
                this.paintBlock(g, buf, cursorPos, cursorEnabled, 3);
                if (numChars - this.offset > 4) {
                    this.paintBlock(g, buf, cursorPos, cursorEnabled, 3);
                }
                this.paintBlock(g, buf, cursorPos, cursorEnabled, numChars - this.offset);
            }
            this.height = this.y + this.lineHeight;
        } else {
            if (cursorEnabled && g != null) {
                g.drawLine(0, 0, 0, this.lineHeight);
            }
            this.height = this.lineHeight;
        }
    }

    int contentChanged(char[] buf, int numChars, int fromPos, int curPos) {
        if (this.width == -1) {
            return 0;
        }
        int oldHeight = this.height;
        this.paint(null, buf, numChars, false, 0, false);
        return this.height - oldHeight;
    }

    int moveCursor(int dir, int curPos, char[] buf, int numChars) {
        switch (dir) {
            case 2: {
                if (curPos <= 0) break;
                --curPos;
                break;
            }
            case 5: {
                if (curPos >= numChars) break;
                ++curPos;
            }
        }
        return curPos;
    }

    int constrainedSize(int size, char[] buffer) {
        int maxNumCharsAllowed = (Display.WIDTH - 8) / this.f.charWidth('9');
        int currentH = (Display.HEIGHT - 8) / this.lineHeight;
        maxNumCharsAllowed = currentH >= 3 ? (maxNumCharsAllowed *= 2) : (maxNumCharsAllowed -= this.lineHeight);
        maxNumCharsAllowed = buffer.length == 0 || buffer[0] == '1' ? (maxNumCharsAllowed += 7) : (maxNumCharsAllowed += 6);
        if (size > maxNumCharsAllowed) {
            return maxNumCharsAllowed;
        }
        return size;
    }

    int getMaxWidth(int allowedWidth, int maxSize) {
        return allowedWidth;
    }

    int getMinimumHeight(int totalHeight) {
        int currentH = (totalHeight - 8) / this.lineHeight;
        if (currentH >= 3) {
            return 3 * this.lineHeight;
        }
        return 2 * this.lineHeight;
    }
}

