/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ksecurity;

import com.sun.ksecurity.CryptoException;
import com.sun.ksecurity.KeyBuilder;
import com.sun.ksecurity.RSAPrivateKey;
import com.sun.ksecurity.RSAPublicKey;

final class RSAKey
implements RSAPublicKey,
RSAPrivateKey {
    byte kind;
    short bitsize;
    boolean initOk;
    byte[] exp = null;
    byte[] mod = null;

    RSAKey(byte type, short len) {
        this.kind = type;
        this.bitsize = len;
        this.initOk = false;
    }

    public void clearKey() {
        this.initOk = false;
        this.bitsize = 0;
    }

    public boolean equals(RSAPrivateKey k) {
        return this.equals((RSAKey)k);
    }

    public boolean equals(RSAPublicKey k) {
        return this.equals((RSAKey)k);
    }

    public boolean equals(RSAKey k) {
        byte[] kexp = new byte[this.exp.length];
        byte[] kmod = new byte[this.mod.length];
        if (this.kind != k.getType()) {
            return false;
        }
        if (k.getExponent(kexp, (short)0) != this.exp.length) {
            return false;
        }
        if (k.getModulus(kmod, (short)0) != this.mod.length) {
            return false;
        }
        int i = 0;
        while (i < this.exp.length) {
            if (kexp[i] != this.exp[i]) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.mod.length) {
            if (kmod[i2] != this.mod[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public short getSize() {
        return (short)(this.bitsize + 63 >>> 6 << 6);
    }

    public byte getType() {
        return this.kind;
    }

    public boolean isInitialized() {
        return this.initOk;
    }

    public short getExponent(byte[] buf, short off) {
        if (this.kind != 2 && this.kind != 1 || !this.initOk) {
            return 0;
        }
        if (off + this.exp.length > buf.length) {
            return 0;
        }
        System.arraycopy(this.exp, 0, buf, off, this.exp.length);
        return (short)this.exp.length;
    }

    public short getModulus(byte[] buf, short off) {
        if (this.kind != 2 && this.kind != 1 || !this.initOk) {
            return 0;
        }
        if (off + this.mod.length > buf.length) {
            return 0;
        }
        System.arraycopy(this.mod, 0, buf, off, this.mod.length);
        return (short)this.mod.length;
    }

    public void setExponent(byte[] buf, short off, short len) throws CryptoException {
        if (this.kind != 2 && this.kind != 1) {
            return;
        }
        int cnt = this.getSize() >>> 3;
        if (len > cnt) {
            throw new CryptoException(2);
        }
        this.exp = new byte[len];
        System.arraycopy(buf, off, this.exp, 0, len);
        if (this.mod != null) {
            this.initOk = true;
        }
    }

    public void setModulus(byte[] buf, short off, short len) throws CryptoException {
        if (this.kind != 2 && this.kind != 1) {
            return;
        }
        int cnt = this.getSize() >>> 3;
        if (len > cnt) {
            throw new CryptoException(2);
        }
        this.mod = new byte[cnt];
        System.arraycopy(buf, off, this.mod, cnt - len, len);
        if (this.exp != null) {
            this.initOk = true;
        }
    }

    public String toString() {
        return "[" + this.getSize() + "-bit RSA " + (this.kind == 1 ? "Public" : "Private") + " key, Exponent: 0x" + KeyBuilder.hexEncode(this.exp) + ",  Modulus: 0x" + KeyBuilder.hexEncode(this.mod) + "]";
    }
}

