
#ifndef IIRSCRAM_TYPE_DEFINITION_HH
#define IIRSCRAM_TYPE_DEFINITION_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Malolan Chetlur    
//          Krishnan Subramani 
//          Umesh Kumar V. Rajasekaran
//          Radharamanan Radhakrishnan
//          Narayanan Thondugulam
//          Swaminathan Subramanian

//---------------------------------------------------------------------------
#include "IIRBase_TypeDefinition.hh"

class IIR_ScalarTypeDefinition;
class IIR_FunctionDeclaration;
class IIR_RangeTypeDefinition;
class IIR_Name;
class IIR_Attribute;
class IIR_TypeDeclaration;
class IIR_ElementDeclarationList;

/** The extension class for IIR_TypeDefinition. */
class IIRScram_TypeDefinition : public IIRBase_TypeDefinition {

public:
  virtual void _publish_vhdl(ostream &);

  virtual IIR_Boolean _is_resolved() { return TRUE; }
  virtual IIR_Boolean _is_anonymous();
  virtual IIR_Boolean _is_bit_type();
  virtual IIR_Boolean _is_line_type();
  virtual IIR_Boolean _is_boolean_type();
  virtual IIR_Boolean _is_file_type() {return FALSE;}
  virtual IIR_Boolean _is_single_dimensional_array_type(){ return FALSE; }
  virtual IIR_Boolean _is_incomplete_type_definition(){ return FALSE; }
  virtual IIR_Boolean _designates_incomplete_type(){ return FALSE; }

  //The following function return TRUE if the elements of the
  //array type or any field of record type is an access type
  virtual IIR_Boolean _has_access_type() { return FALSE; }

  virtual IIR_Boolean _is_subtype();
  virtual IIR_Boolean _is_subtype_decl();
  
  virtual IIR_Boolean _is_element();
  virtual IIR_Boolean _is_resolved_type();

  virtual IIR_Boolean _is_iir_type_definition() { return TRUE; }
  virtual IIR_Boolean _is_kernel_type();

  // c++ code generation methods

  virtual void _publish_cc_left( published_file &_cc_out );
  virtual void _publish_cc_right( published_file &_cc_out );
  virtual void _publish_cc_decl_cc( published_file &_cc_out );

  /** Generates the type name and publishes it to the currently publishing
      file. */
  const string _get_cc_type_name() = 0;

  virtual void _publish_cc_base_type_name( published_file &_cc_out );
  virtual void _publish_cc_decl_type_attributes( published_file &_cc_out );
  virtual void _publish_cc_universal_left( published_file &_cc_out );
  virtual void _publish_cc_bounds( published_file &_cc_out );

  /** This method, currently only defined for scalar, range, and array
      types, publishes a Tyvis ArrayInfo structure corresponding this
      type. */
  virtual void _publish_cc_array_info( published_file &_cc_out );

  virtual void _publish_cc_lvalue( published_file &_cc_out );

  virtual void _publish_cc_lvalue( ostream &_cc_out );
  
  void _publish_cc_function_leftvalue( published_file &_cc_out );
//   virtual void _publish_cc_concatenation_operator( published_file &_cc_out );
//   virtual void _publish_cc_concatenation_operator_prototype( published_file &_cc_out );
  virtual void _publish_cc_decl_predefined_procedures_prototypes( published_file &_cc_out );

  virtual void _publish_cc_necessary_decl_in_state( published_file &_cc_out );
  virtual void _publish_cc_init_fields_for_signals( published_file &_cc_out );

  virtual void _publish_cc_subelement_type( published_file &_cc_out );
  virtual void _publish_cc_anonymous_type_name( ostream &os );
  virtual void _publish_cc_type_info( published_file &_cc_out );
  virtual void _publish_cc_constructor_args_type_info( published_file &_cc_out,
						       IIR *initializer );
  void _publish_cc_constructor_args_type_info_composite_type( published_file &_cc_out,
							      IIR *initializer );

  virtual void _publish_cc_type_info_scoping_prefix( published_file &_cc_out,
						     const IIR_Boolean commaFlag = TRUE);

  virtual void _publish_cc_object_type_info( published_file &_cc_out,
					     const IIR_Boolean commaFlag = TRUE, 
					     const char *additionalSuffix = NULL, 
					     const IIR_Boolean temporaryFlag = FALSE);
  virtual void _publish_cc_extern_type_info( published_file &_cc_out );
  virtual IIR* _get_elaboration_class();

  /** Returns what the code generator expects as a parent type.  If there
     is none, returns "this". */
  IIR_TypeDefinition *_get_parent_type();
  
  virtual IIR_TypeDefinition *get_across(); 
  virtual IIR_TypeDefinition *get_through();  
  
  virtual void _publish_cc_type_string( published_file & ){}
  virtual void _publish_cc_init_val( published_file & ) {
    _report_undefined_scram_fn("_publish_cc_init_val( published_file &_cc_out )");
  }

  virtual void _publish_cc_temporary_type_info( published_file &_cc_out, 
						char * = NULL, 
						char * = NULL );

  virtual void _publish_cc_typeInfo( published_file &_cc_out );
  virtual void _publish_cc_class( published_file &_cc_out );
  virtual void _publish_cc_parent_type_name( published_file &_cc_out );
  virtual void _publish_cc_data_members( published_file &_cc_out );

  virtual void _publish_cc_decl_constructors( published_file &_cc_out );
  virtual void _publish_cc_type_constructors( published_file &_cc_out );
  virtual void _publish_cc_subtype_constructors( published_file &_cc_out );

  virtual void _publish_cc_decl_destructors( published_file &_cc_out );
  virtual void _publish_cc_type_destructors( published_file &_cc_out );
  virtual void _publish_cc_subtype_destructors( published_file &_cc_out );

  virtual void _publish_cc_type_operator_equalto( published_file &_cc_out );
  virtual void _publish_cc_decl_operator_subscript( published_file &_cc_out );
  virtual void _publish_cc_subtype_operator_equalto( published_file &_cc_out );
  virtual void _publish_cc_decl_operator_equalto( published_file &_cc_out );

  virtual void _publish_cc_decl_event_class(const char *);
  
  virtual void _publish_cc_elaborate( published_file &_cc_out );
//   virtual void _publish_cc_class_event( published_file &_cc_out );
//   virtual void _publish_cc_class_last_event( published_file &_cc_out );

  virtual void _publish_cc_headers( published_file &_cc_out );

  /** Publishes the appropriate include for this type. */
  virtual void _publish_cc_include( published_file &_cc_out );
  /** Convenience - to "unhide" the one in IIRScram. */
  virtual void _publish_cc_include( published_file &os, const string &to_include );

  /** Publishes the resolution function id for resolved types, "-1" for
      types that aren't resolved. */
  void _publish_cc_resolution_function_id( published_file &_cc_out );
  void _publish_cc_set_resolution_function( published_file &_cc_out );

  /** This method sets the resolution function for types that are
     allowed to have them.  An internal error will be generated if
     called on file or access types.  */
  virtual void _set_resolution_function( IIR_FunctionDeclaration * ) = 0;

  void _add_decl_into_cgen_symbol_table();

  /** These functions publishes the code needed in the initializtion of any
      signal These functions unrolls the composite type to their individual
      non composite types */
  virtual void _publish_cc_init_signal( published_file &_cc_out );  

  /** These functions publishes the code needed in the initializtion of any
      variable These functions unrolls the composite type to their
      individual non composite types. */
  virtual void _publish_cc_composite_init( published_file &_cc_out );  
  
  /** This function publishes the code needed for the initializaion of any
      quantity */
  virtual void _publish_cc_init_quantity( published_file &_cc_out );
  
  IIR_TypeDefinition *_get_bottom_base_type();
  
  IIR_TypeDefinition *get_subtype(){ return (IIR_TypeDefinition *)this; }

  /** This method returns a pointer to the most constrained common
   subtype of "this" type, and the one passed in.  It returns NULL if
   the types are not compatible at all. */
  IIR_TypeDefinition *_is_compatible( IIR_TypeDefinition * );
  virtual IIR_TypeDefinition *_check_special_compatible( IIR_TypeDefinition * );

  /** If this type is not anonymous, it prints declaration's name.
      Otherwise, it prints "ANONYMOUS". */
  IIR_TextLiteral *_get_declarator();

  virtual IIR *_get_direction();

  virtual IIR_TypeDefinition *_get_base_type();

  // A scalar subtype may return NULL as it's left even if it has a range
  // constraint.  These methods will travel down to the first base type
  // that has a left defined.  Similarly for right and direction.
  virtual IIR* _get_base_type_left();
  virtual IIR* _get_base_type_direction();
  virtual IIR* _get_base_type_right();

  /** If this is a record type (or an access to a record type?), it returns
      it's element list.  Otherwise it returns NULL. */
  virtual IIR_ElementDeclarationList *_get_element_declarations(){ return NULL; }

  /** If this is an array type (or an access to an array type?), returns
      it's element subtype.  Otherwise, it complains and aborts! */
  virtual IIR_TypeDefinition *_get_element_subtype();
  virtual IIR_ScalarTypeDefinition *_get_index_subtype();
  virtual void _set_index_subtype(  IIR_ScalarTypeDefinition * );
  virtual void _set_element_subtype(  IIR_TypeDefinition * );
  virtual IIR_Int32 _get_num_indexes();
  virtual IIR_TypeDefinition *_get_type_of_element( int );

  virtual IIR_TypeDefinition *_is_explicit_type_conversion_needed(IIR_TypeDefinition *);
  virtual IIR_Boolean _is_base_type(IIR_TypeDefinition *);

  /** This method builds a new array subtype by index constraining this
      one.  You can index constrain an access to an array type, so it's
      defined here. */
  virtual IIR_TypeDefinition *_index_constrain_array( IIR_ScalarTypeDefinition * );
  
  virtual IIR_Boolean _is_array_type(){
    return FALSE;
  }

  virtual IIR_Boolean _is_unconstrained_array_type(){
    return FALSE;
  }

  ostream &_print( ostream & );

  virtual set<IIR_Declaration> *_find_declarations( IIR_Name * );
  virtual set<IIR_Declaration> *_find_declarations( IIR_TextLiteral * );
  
  /** This method takes a range type definition, and constructs an
      IIR_IntegerTypeDefinition, IIR_FloatingTypeDefinition. It
      allocates memory to hand back to the caller. */
  static IIR_ScalarTypeDefinition *_construct_new_type( IIR_RangeTypeDefinition *,
							IIR_TypeDeclaration * );

  set<IIR_TypeDefinition> *_get_rval_set( IIR_Boolean (IIR::*constraint_function)() = 0 );
  void _type_check( set<IIR_TypeDefinition> * );

  /** Provides an entry into type checking a type definition.  By
     default, this does nothing.  If it's been overridden, then it does
     whatever the descendent type wants done in terms of type checking.  */
  virtual void _type_check(){}


  virtual IIR_TypeDefinition *
  _construct_new_subtype( IIR_Name *resolution_function,
			  IIR_ScalarTypeDefinition *new_constraint );

  virtual IIR_TypeDefinition *_get_new_subtype();

  static IIR_FunctionDeclaration *_resolve_resolution_function( IIR_Name * );

  virtual IIR_FunctionDeclaration *_get_resolution_function();

  IIR_TypeDefinition *
  _construct_new_subtype_resolution_function_only( IIR_Name *resolution_function );

  virtual void _clone( IIR * );
  
  virtual IIR_Boolean is_element();
  virtual void set_is_element( IIR_Boolean );  
  
  /** This gives a type a chance to build operators, functions, and do
      other housekeeping. */
  virtual void _come_into_scope( symbol_table *, IIR_TypeDeclaration * );
  virtual void _come_out_of_scope( symbol_table * ){}

  /** For access subtypes, this method returns the type that is accessed.
      For other types/subtypes, this will generate a runtime error.  */
  virtual IIR_TypeDefinition *_get_designated_subtype();

protected:
  IIRScram_TypeDefinition();

  virtual ~IIRScram_TypeDefinition() = 0;

  virtual void _build_implicit_operators( set<IIR_Declaration> *add_to );
  void _build_implicit_operator( char *op,
				 set<IIR_Declaration> *add_to,
				 IIRScram_TypeDefinition *return_type, 
				 IIRScram_TypeDefinition *left_type,
				 IIRScram_TypeDefinition *right_type = NULL );

  void _build_implicit_operators( char *ops[],
				  set<IIR_Declaration> *add_to,
				  IIRScram_TypeDefinition *return_type,
				  IIRScram_TypeDefinition *left_type,
				  IIRScram_TypeDefinition *right_type = NULL );

  void _build_logical_operators( set<IIR_Declaration> *add_to );
  void _build_ordering_operators( set<IIR_Declaration> *add_to );

private:
  static IIR_ScalarTypeDefinition *_determine_type_of_bound( IIR *left_or_right );

  IIR_Attribute *my_attribute;
};
#endif
