
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Radharamanan Radhakrishnan

#include "IIRScram_TypeConversion.hh"
#include "IIR_AssociationElementByExpression.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_AssociationList.hh"
#include "IIR_PosAttribute.hh"
#include "IIR_FunctionCall.hh"
#include "IIR_Identifier.hh"
#include "IIR_SubprogramDeclaration.hh"
#include "set.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_TypeConversion::~IIRScram_TypeConversion(){}

void 
IIRScram_TypeConversion::_publish_vhdl(ostream &_vhdl_out) {
  get_type_mark()->_get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "(";
  get_expression()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ")";
}

void
IIRScram_TypeConversion::_publish_cc_headers( published_file &_cc_out ) {
  get_type_mark()->_publish_cc_include( _cc_out );
}

void
IIRScram_TypeConversion::_publish_cc_lvalue( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_TypeConversion::_publish_cc" );

  if ( get_type_mark()->_is_array_type() == FALSE &&
      get_type_mark()->_is_scalar_type() == FALSE ){
    get_expression()->_publish_cc_lvalue( _cc_out );
  }
  else{
    _cc_out << get_type_mark()->_get_cc_type_name();
    _cc_out << "(ObjectBase::VARIABLE, ";
    if (get_type_mark()->_is_scalar_type() == TRUE) {
      get_type_mark()->_publish_cc_universal_type( _cc_out );
      _cc_out << "::typeCast((";
      get_expression()->get_subtype()->_publish_cc_universal_type( _cc_out );
      _cc_out << " &)";
      get_expression()->_publish_cc_lvalue( _cc_out );
      _cc_out << ".readVal())";
      get_type_mark()->_publish_cc_object_type_info( _cc_out );
    }
    else if (get_type_mark()->_is_array_type() == TRUE) {
      get_type_mark()->_publish_cc_object_type_info( _cc_out, FALSE, NULL, TRUE );
      _cc_out << ", ";
      get_type_mark()->_publish_cc_resolution_function_id(_cc_out);
      _cc_out << ", ";      
      get_expression()->_publish_cc_lvalue( _cc_out );
    }
    _cc_out << ")";
  }
}

void
IIRScram_TypeConversion::_get_list_of_input_signals( set<IIR> *list ){
  get_expression()->_get_list_of_input_signals(list);
}

void
IIRScram_TypeConversion::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  get_expression()->_build_sensitivity_list(sensitivity_list);
}

ostream & 
IIRScram_TypeConversion::_print( ostream &os ) {
  os << *get_type_mark();
  os << " ( ";
  os << *get_expression();
  os << " ) ";
  
  return os;
}
 
IIR_Boolean
IIRScram_TypeConversion::_is_resolved(){
  IIR_Boolean retval = TRUE;
  if ( get_type_mark()->_is_resolved() == FALSE || get_expression()->_is_resolved() == FALSE ){
    retval = FALSE;
  }

  return retval;
}

IIR_TypeDefinition *
IIRScram_TypeConversion::get_subtype(){
  return get_type_mark();
}


set<IIR_TypeDefinition> *
IIRScram_TypeConversion::_get_rval_set(IIR_Boolean (IIR::*constraint_function)() ){
  return new set<IIR_TypeDefinition>(get_subtype());
}

IIR_Declaration *
IIRScram_TypeConversion::_find_formal_declaration(){
  ASSERT( _is_resolved() == TRUE );
  ASSERT( get_expression() != NULL );
  ASSERT( get_expression()->get_kind() != IIR_ASSOCIATION_LIST || 
	  ((IIR_AssociationList *)get_expression())->num_elements() == 1 );
  ASSERT( get_type_mark() != NULL );
  return get_type_mark()->_find_formal_declaration();
}

IIR_Boolean 
IIRScram_TypeConversion::_is_locally_static_primary(){
  ASSERT( get_expression() != NULL );
  ASSERT( get_expression()->_is_resolved() == TRUE );

  return get_expression()->_is_locally_static();
}

IIR_Boolean 
IIRScram_TypeConversion::_is_globally_static_primary(){
  ASSERT( get_expression() != NULL );
  ASSERT( get_expression()->_is_resolved() == TRUE );

  return get_expression()->_is_globally_static();
}

visitor_return_type *
IIRScram_TypeConversion::_accept_visitor( node_visitor *visitor, 
					  visitor_argument_type *arg ){
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_TypeConversion(this, arg);
}

void
IIRScram_TypeConversion::_publish_cc_ams_function(published_file &_cc_out) {
  IIR_PosAttribute *pos_attr = NULL;
  IIR_TextLiteral *func_declarator = NULL;
  if(get_expression()->get_kind() == IIR_POS_ATTRIBUTE) {
    pos_attr = ((IIR_PosAttribute*)get_expression());
    if(pos_attr->get_suffix()->get_kind() == IIR_FUNCTION_CALL) {
      func_declarator =
        ((IIR_FunctionCall*)pos_attr->get_suffix())->get_implementation()->get_declarator();
      if((IIRScram_Identifier::_cmp(func_declarator, "now") == 0)) {
        if(_get_currently_publishing_unit() == IIRScram::SIMULTANEOUS_STATEMENT) {
         _cc_out << "  new equationNode('T',0,node"
                 << (int)(_stmt_node_index/2) << ");" << NL();
        }
      }
    }
  }
}
  
void
IIRScram_TypeConversion::_set_stmt_node_index(IIR_Int32 *index, bool _is_right_child, bool &reducibleFlag) {
  if (_is_right_child == true) {
   _stmt_node_index = 2 * (*index)+ 1;
  }
  else {
   _stmt_node_index = 2 * (*index);
  }
}

