// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram_PackageBodyDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_TypeDeclaration.hh"
#include "IIR_FileDeclaration.hh"
#include "symbol_table.hh"
#include "error_func.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


extern symbol_table *cgen_sym_tab_ptr;

IIRScram_PackageBodyDeclaration::IIRScram_PackageBodyDeclaration() {
  cgen_sym_tab_ptr = NULL;
}

IIRScram_PackageBodyDeclaration::~IIRScram_PackageBodyDeclaration() {}

void 
IIRScram_PackageBodyDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  PublishedUnit oldUnit;
  
  context_items._publish_vhdl(_vhdl_out);

  oldUnit = _get_currently_publishing_vhdl_unit();
  _set_currently_publishing_vhdl_unit(IIRScram::PACKAGE_BODY);
  
  _vhdl_out << "package body ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " is\n";
  package_declarative_part._publish_vhdl_decl(_vhdl_out);
  _vhdl_out << "end package body ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";

  _set_currently_publishing_vhdl_unit(oldUnit);
}

void 
IIRScram_PackageBodyDeclaration::_publish_cc_package_name( ostream &os ){
  os << *_get_declarator() << "Pkg";
}

void
IIRScram_PackageBodyDeclaration::_publish_cc_binding_name( ostream &os ){
  _publish_cc_package_name( os );
}

void 
IIRScram_PackageBodyDeclaration::_publish_cc(){
  ostringstream package_body_name;
  symbol_table cgen_sym_tab( 4093, false );
  
  _set_currently_publishing_unit(IIRScram::PACKAGE_BODY);

  cgen_sym_tab_ptr = &cgen_sym_tab;

  _publish_cc_hh_file();
  _publish_cc_cc_file();

  _publish_cc_package_name( package_body_name );
  _set_current_package_body_name( package_body_name.str() );

  cgen_sym_tab_ptr = NULL;

  _set_currently_publishing_unit(NONE);
}

void
IIRScram_PackageBodyDeclaration::_publish_cc_hh_file(){
  const string filename = _get_cc_filename();
  published_header_file header_file( _get_library_directory(),
				     filename,
				     this,
				     ios::app | ios::out );

  SCRAM_CC_REF( header_file, "IIRScram_PackageBodyDeclaration::_publish_cc_hh_file" );
  
  header_file << "#undef " << filename << "_hh\n";

  context_items._publish_cc( header_file );
  _publish_cc_headers( header_file );
 
  // package_declarative_part._publish_cc_extern_type_info( header_file );
  package_declarative_part._publish_cc_package_declarations( header_file );

  SCRAM_CC_REF( header_file, "IIRScram_PackageBodyDeclaration::_publish_cc_hh_file" );
}

void
IIRScram_PackageBodyDeclaration::_publish_cc_cc_file(){
  const string filename = _get_cc_filename();

  published_cc_file cc_file( _get_library_directory(), 
			     filename,
			     this,
			     ios::app | ios::out );

  SCRAM_CC_REF( cc_file, "IIRScram_PackageBodyDeclaration::_publish_cc_cc_file" );
  IIR_Declaration *decl = package_declarative_part.first();

  _publish_cc_include_decls( cc_file );

  //initialize the decl
  decl = package_declarative_part.first();
  for(;decl != NULL; decl = package_declarative_part.successor(decl)) {
    switch(decl->get_kind()) {
    case IIR_CONSTANT_DECLARATION:
      //nothing to do since already published
      ((IIR_ConstantDeclaration *) decl)->_publish_cc_init_package_constant( cc_file );
      break;
    case IIR_TYPE_DECLARATION:
    case IIR_SUBTYPE_DECLARATION:
      decl->_publish_cc_type_info( cc_file );
      break;
    case IIR_PROCEDURE_DECLARATION:
    case IIR_FUNCTION_DECLARATION:
      decl->_publish_cc_decl( cc_file );
      break;
    case IIR_COMPONENT_DECLARATION:
    case IIR_USE_CLAUSE:
      break;
    case IIR_FILE_DECLARATION:  // This is a guess - DEM
      ((IIR_FileDeclaration *) decl)->_publish_cc_shared_file_decl( cc_file );
      break;
    default:{
      ostringstream err;
      err << "Unimplemented declaration type: " << decl->get_kind_text()
	  << " in IIRScram_PackageBodyDeclaration::_publish_cc_cc_file( published_file &cc_file ).";
      report_error( decl, err.str() );
      break;
    }
    }
  }
}

void 
IIRScram_PackageBodyDeclaration::_publish_cc_headers( published_file &_cc_out ) {
  IIR *old_node = _get_current_publish_node();
  _set_current_publish_node( this );
  IIRScram::_publish_cc_include( _cc_out, "tyvis/VHDLProcess.hh" );
  IIR_Declaration *decl = package_declarative_part.first();
  while (decl != NULL) {
    decl->_publish_cc_include( _cc_out );
    decl = package_declarative_part.successor(decl);
  }
  _set_current_publish_node( old_node );
}  

void
IIRScram_PackageBodyDeclaration::_publish_cc_include_decls_prefix( ostream &os ){
  _publish_cc_package_name( os );
}

IIRScram_Declaration::declaration_type 
IIRScram_PackageBodyDeclaration::_get_type(){
   return PACKAGE_BODY;
}

visitor_return_type *
IIRScram_PackageBodyDeclaration::_accept_visitor( node_visitor *visitor, 
						  visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_PackageBodyDeclaration(this, arg);
}

const string 
IIRScram_PackageBodyDeclaration::_get_cc_filename(){
  ostringstream str;
  _publish_cc_package_name( str );
  return str.str();
}

