
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING
// OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found
// in the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Malolan Chetlur    
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam

#include "IIR_IfStatement.hh"
#include "IIR_Elsif.hh"
#include "IIR_Label.hh"
#include "IIR_EnumerationSubtypeDefinition.hh"
#include "resolution_func.hh"
#include "IIR_AboveAttribute.hh"
#include "StandardPackage.hh"
#include "set.hh"
#include "published_file.hh"

extern bool parse_error;

IIRScram_IfStatement::~IIRScram_IfStatement() {}

void 
IIRScram_IfStatement::_publish_vhdl(ostream &_vhdl_out) {

  _publish_vhdl_stmt_label(_vhdl_out);
    
  _vhdl_out << "if (";
  get_condition()->_publish_vhdl(_vhdl_out);
    
  _vhdl_out << ") then\n";
    
  if (then_sequence.num_elements() != 0) {
    then_sequence._publish_vhdl(_vhdl_out);
  }
    
  if (get_elsif() != NULL) {
    get_elsif()->_publish_vhdl(_vhdl_out);
  }
    
  if (else_sequence.num_elements() != 0) {
    _vhdl_out << " else\n";
    else_sequence._publish_vhdl(_vhdl_out);
  }
  _vhdl_out << "end if";
}

void 
IIRScram_IfStatement::_publish_cc( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_IfStatement::_publish_cc" );
  if (get_label() != NULL) {
    get_label()->_publish_cc_lvalue( _cc_out );
    _cc_out << ":" << NL();
  }
    
  _cc_out << OS("if( SAVANT_BOOLEAN_TRUE  == ");
  get_condition()->_publish_cc_rvalue( _cc_out );
  _cc_out << CS(")") << OS("{");
    
  if( then_sequence.num_elements() > 0 ){
    then_sequence._publish_cc( _cc_out );
  }
  _cc_out << CS("}");

  if( get_elsif() ){
    get_elsif()->_publish_cc( _cc_out );
  }

  if( else_sequence.num_elements() > 0){
    _cc_out << OS("else {");
    else_sequence._publish_cc( _cc_out );
    _cc_out << CS("}");
  }
}

void
IIRScram_IfStatement::_publish_cc_decl_for_loop_iterator( published_file &_cc_out ) {
  then_sequence._publish_cc_decl_for_loop_iterator( _cc_out );
  if (get_elsif() != NULL) {
    get_elsif()->_publish_cc_decl_for_loop_iterator( _cc_out );
  }
  else_sequence._publish_cc_decl_for_loop_iterator( _cc_out );
}

void
IIRScram_IfStatement::_build_wait_list(dl_list<IIRScram_WaitStatement>* list) {
  then_sequence._build_wait_list(list);
  if (get_elsif() != NULL) {
    get_elsif()->_build_wait_list(list);
  }
  else_sequence._build_wait_list(list);
}

void 
IIRScram_IfStatement::_build_procedure_call_stmt_list(dl_list<IIR_ProcedureCallStatement> *list) {
  then_sequence._build_procedure_call_stmt_list(list);
  if (get_elsif() != NULL) {
    get_elsif()->_build_procedure_call_stmt_list(list);
  }
  else_sequence._build_procedure_call_stmt_list(list);
}

void
IIRScram_IfStatement::_get_list_of_input_signals( set<IIR>* list ){
  get_condition()->_get_list_of_input_signals(list);
  if (get_elsif() != NULL) {
    get_elsif()->_get_list_of_input_signals(list);
  }
  then_sequence._get_list_of_input_signals(list);
  else_sequence._get_list_of_input_signals(list);
}

void
IIRScram_IfStatement::_type_check(){
  IIR *new_condition = _type_check_and_resolve_boolean_condition( get_condition() );
  ASSERT( new_condition != NULL );
  if( parse_error == FALSE ){
    ASSERT( new_condition->_is_resolved() == TRUE );
    set_condition( new_condition );
  }

  IIR_TypeDefinition *bool_type = StandardPackage::get_boolean_type();

  if ( get_elsif() != NULL ){
    get_elsif()->IIRScram::_type_check( bool_type );
  }
}

IIR_Boolean 
IIRScram_IfStatement::_type_check_return_statements( set<IIR_TypeDefinition> *context_set, IIR_SubprogramDeclaration *subprogram_decl ){
  IIR_Boolean retval = false;

  IIR_Boolean retval1 = false;
  retval1 = 
    IIR_SequentialStatement::_type_check_return_statements( context_set, &then_sequence, subprogram_decl );
  
  IIR_Boolean retval2 = false;
  retval2 = 
    IIR_SequentialStatement::_type_check_return_statements( context_set, &else_sequence, subprogram_decl );

  IIR_Boolean retval3 = false;
  if ( get_elsif() != NULL ){
    retval3 =
      get_elsif()->_type_check_return_statements(context_set, subprogram_decl);
  }

  if ( retval1 == TRUE || retval2 == TRUE || retval3 == TRUE ){
    retval = TRUE;
  }

  return retval;
}

void
IIRScram_IfStatement::_get_signal_source_info( set<IIR> *siginfo ){
  if (get_elsif() != NULL) {
    get_elsif()->_get_signal_source_info(siginfo);
  }
  then_sequence._get_signal_source_info(siginfo);
  else_sequence._get_signal_source_info(siginfo);
}

IIR_Boolean
IIRScram_IfStatement::_is_above_attribute_found() {
  IIR_Boolean retval = FALSE;

  ASSERT(get_condition() != NULL);

  retval = retval || get_condition()->_is_above_attribute_found();

  if (then_sequence.num_elements() != 0) {
    retval = retval || then_sequence._is_above_attribute_found();
  }
  if (get_elsif() != NULL) {
    retval = retval || get_elsif()->_is_above_attribute_found();
  }
  if (else_sequence.num_elements() != 0) {
    retval = retval || else_sequence._is_above_attribute_found();
  }
  return retval;
}

void
IIRScram_IfStatement::
_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  ASSERT(get_condition() != NULL);
  get_condition()->_build_above_attribute_set(to_build);
  if (then_sequence.num_elements() != 0) {
    then_sequence._build_above_attribute_set(to_build);
  }
  if (get_elsif() != NULL) {
    get_elsif()->_build_above_attribute_set(to_build);
  }
  if (else_sequence.num_elements() != 0) {
    else_sequence._build_above_attribute_set(to_build);
  }
}

IIR*
IIRScram_IfStatement::_clone() {
  IIR_IfStatement *clone = new IIR_IfStatement();
  IIRScram::_clone( clone );
  IIR *condition = get_condition();
  IIR_SequentialStatement *stmt, *newstmt;
  IIR_Elsif *elsif;

  clone->set_label(get_label());
  condition = condition->_clone();
  clone->set_condition(condition);

  stmt = then_sequence.first();
  while (stmt != NULL) {
    newstmt = (IIR_SequentialStatement*)stmt->_clone();
    clone->then_sequence.append(newstmt);
    stmt = then_sequence.successor(stmt);
  }

  stmt = else_sequence.first();
  while (stmt != NULL) {
    newstmt = (IIR_SequentialStatement*)stmt->_clone();
    clone->else_sequence.append(newstmt);
    stmt = else_sequence.successor(stmt);
  }
  elsif = get_elsif();
  if (elsif != NULL) {
    elsif = (IIR_Elsif*)elsif->_clone();
  }
  clone->set_elsif(elsif);

  return clone;
}

visitor_return_type *IIRScram_IfStatement::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_IfStatement(this, arg);
};
