
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Harish Venkataramani venkath@ececs.uc.edu

#include "IIRScram_DotAttribute.hh"
#include "IIR_BranchQuantityDeclaration.hh"
#include "IIR_FreeQuantityDeclaration.hh"
#include "published_file.hh"
#include "IIR_StringLiteral.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "IIR_Identifier.hh"
#include "symbol_table.hh"
#include "IIR_TypeDeclaration.hh"
#include "error_func.hh"
#include "sstream-wrap.hh"

extern symbol_table *cgen_sym_tab_ptr;
extern symbol_table *cgen_arch_sym_tab_ptr;

using std::ends;

IIRScram_DotAttribute::~IIRScram_DotAttribute() {}

void
IIRScram_DotAttribute::_publish_vhdl(ostream &_vhdl_out) {
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'DOT " ;
}

IIR_TextLiteral *
IIRScram_DotAttribute::_build_attribute_name(){
  char *name = "dot";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_DotAttribute::get_subtype() {
  IIR *my_prefix = get_prefix();
  set<IIR_Declaration> *quantity_decl_set = NULL;
  quantity_decl_set = my_prefix->_symbol_lookup();
  IIR_Declaration *quan_decl = NULL;
  
  if (quantity_decl_set == NULL) {
    report_undefined_symbol(my_prefix);
    return NULL;
  }
  
  quan_decl = quantity_decl_set->get_element();
  while (quan_decl != NULL) {
    if (quan_decl->_is_quantity() == FALSE) {
      quantity_decl_set->remove(quan_decl);
    }
    quan_decl = quantity_decl_set->get_next_element();
  }
  switch(quantity_decl_set->num_elements()) {
  case 0: {
    ostringstream cerr;
    cerr << "|" << _get_attribute_name() 
	 << "| may only be applied to terminals." << endl;
    return NULL;
  }
    break;
  case 1: {
    set_prefix(quantity_decl_set->get_element());
  }
    break;
  default: {
    report_ambiguous_error(my_prefix, quantity_decl_set);
    return NULL;
  }
  }
  return get_prefix()->get_subtype();
}

IIR_Declaration *
IIRScram_DotAttribute::_get_implicit_declaration( const string &decl_name,
						  IIR_TypeDefinition *decl_nature ){
  if ( get_prefix()->get_kind() == IIR_FREE_QUANTITY_DECLARATION ) {
    return (IIR_Declaration*)_build_free_quantity_declaration( decl_name, decl_nature );
  }
  else if ( get_prefix()->get_kind() == IIR_BRANCH_QUANTITY_DECLARATION ) {
    return (IIR_Declaration*)_build_branch_quantity_declaration( decl_name, decl_nature);
  } 
  else {
    ostringstream cerr;
    cerr << "|" << *get_prefix() 
	 << "| - Dot Attribute may only be applied to quantities." << endl;
    return NULL;
  }
}

void
IIRScram_DotAttribute::_set_stmt_qty_index(IIR_Int32 *index, set<IIR_Declaration>
                                           *quantity_set) {
  if (cgen_arch_sym_tab_ptr !=NULL) {
    if (!cgen_arch_sym_tab_ptr->in_scope((IIR_Declaration*)get_prefix())) {
      cgen_arch_sym_tab_ptr->add_declaration((IIR_Declaration*)get_prefix());
    }
  }
  ((IIR_Attribute*)this)->_get_implicit_declaration()-> _set_stmt_qty_index(index,quantity_set);
}

void
IIRScram_DotAttribute::_set_stmt_node_index(IIR_Int32 *index, bool _is_right_child, bool &reducibleFlag) {
  reducibleFlag = false;
  ((IIR_Attribute*)this)->_get_implicit_declaration()->_set_stmt_node_index(index,_is_right_child,reducibleFlag);
}

void
IIRScram_DotAttribute::_publish_cc_ams_function(published_file &_cc_out) {
  ((IIR_Attribute*)this)->_get_implicit_declaration()->_publish_cc_ams_function(_cc_out);
}

IIR_Boolean
IIRScram_DotAttribute::_differential_quantity_found() {
  return TRUE;
}

void
IIRScram_DotAttribute::_build_differential_quantity_list(dl_list<IIR_DotAttribute> *
                                                         differential_quantity_list) {
  differential_quantity_list->append((IIR_DotAttribute*)this);
}
