#ifndef ITERATOR_HH
#define ITERATOR_HH

#include "list.hh"
#include "list_object.hh"

#ifndef NULL
#define NULL (void *)0
#endif

class list;
class list_object;

class iterator {
  friend class list;
public:
  iterator( list * );
  ~iterator( );

  // Stick this object immediately after the one I'm sitting on...
  void append_to_current( list_object * );

  // Go to the head of the list, and return the object you find there...
  list_object *go_to_head( ){
    current_position = my_list->get_head();
    return current_position;
  }

  // Go to the  of the list, and return the object you find there...
  list_object *go_to_tail( ){
    current_position = my_list->get_tail();
    return current_position;
  }
  
  // Move me forward one place, and return the object there...  If we're not
  // on the list, go to the head..
  list_object *forward(){
    list_object *old_position = get_current();

    if( old_position == NULL ){
      return go_to_head();
    }
    else{
      list_object *new_position = move_forward();
      if( get_current() != NULL && old_position != my_list->get_tail() && 
	  old_position != new_position ){
	return get_current();
      }
      else{
      current_position = NULL;
      return NULL;
      }
    }
  }

  // Move me backwards one place, and return the object there...
  list_object *backward(){
    list_object *old_position = get_current();

    if( old_position == NULL ){
      return go_to_tail();
    }
    else{
      list_object *new_position = move_backward();
      if( get_current() != NULL && old_position != my_list->get_head() &&
	  old_position != new_position ){
	return get_current();
      }
      else{
	current_position = NULL;
	return NULL;
      }
    }
  }

  // Give me the object at my current location...
  list_object *get_current(){
    return current_position;
  }

  // Find this object in the list...
  inline 
  list_object *go_to_object( list_object *to_find ){
    register list_object *current = get_current();

    if( current == NULL ){
      current_position = my_list->get_head();
      return current_position;
    }
    else{
      list_object *starting_point = current;
      do {
	if( current == to_find ){
	  return current;
	}
	current = move_forward();
      } while( current != starting_point);
      // If we made it to here, the object wasn't in the list!
      return NULL;
    }
  }

  // Go the the nth element in the list.  Returns NULL if we fall off
  // of the end of the list...
  list_object *go_to_position( unsigned int position );

  // Remove the current object from the list.  Returns it to you as
  // well, to allow easy deletion...  Iterator "backs up" one on the
  // list.
  list_object *remove_current();

  // Remove the object from the list.  Returns it to you as well, to
  // allow easy deletion...  Iterator ends on on element previous to
  // the one removed...
  list_object *go_to_and_remove( list_object * );

  // No - NULL check on purpose - this should be done outside of this 
  // function!  This function moves the iterator forward.  Since the
  // list is built circularlly, if the caller doesn't stop, this method
  // will never return NULL!
  list_object *move_forward(){
    current_position = current_position->get_next();
    return current_position;
  }

  // No - NULL check on purpose - this should be done outside of this 
  // function!  This function moves the iterator forward.  Since the
  // list is built circularlly, if the caller doesn't stop, this method
  // will never return NULL!
  list_object *move_backward(){
    current_position = current_position->get_previous();
    return current_position;
  }

private:
  // This method is called each time an element is removed from the list.
  // That way, if more than one iterator is on this list, we can make
  // sure none of them get stranded on a deleted element...
  void get_off_of( list_object * );

  
  // This points at the element we're currently removing - NULL if we're not.
  list_object *removing_element;
  
  // This is the object we're currently sitting on.
  list_object *current_position;

  // This is the list I'm hooked to.
  list *my_list;
};

#endif
