#ifndef IIRSCRAM_MONADIC_OPERATOR_HH
#define IIRSCRAM_MONADIC_OPERATOR_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_MonadicOperator.hh,v 1.2 1999/03/09 20:55:30 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_MonadicOperator.hh"

class IIRScram_MonadicOperator : public IIRBase_MonadicOperator {

public:
  IIR  *_transmute();

  IIR_Boolean _is_resolved();

  virtual void _publish_cc_operator_name();
  void _publish_cc_wait_data();
  void _publish_cc();
  void _publish_cc_headers();
  void _publish_cc_initialization_value();
  void _get_list_of_input_signals(set<IIR_Declaration>* list);
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);
  ostream &_print( ostream & );

  IIR *_clone();

  virtual void _add_decl_into_cgen_symbol_table();
  void _publish_vhdl(ostream &);
  IIR_Boolean _is_static_expression();
  IIR_Boolean _is_operator();
  IIR_Boolean _is_locally_static_primary();

protected:
  IIR_Int32 _get_num_args(){ return 1; }  
  IIR_AssociationList *_build_argument_list();

  IIRScram_MonadicOperator() {};
  virtual ~IIRScram_MonadicOperator() = 0;

  char *_get_function_name();

  void _type_check_operands( );
    
private:
};
#endif
