
#ifndef IIRBASE_CONCURRENT_STATEMENT_LIST_HH
#define IIRBASE_CONCURRENT_STATEMENT_LIST_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_ConcurrentStatementList.hh,v 1.2 1999/03/09 20:49:17 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_List.hh"

class IIR_ConcurrentStatement;

class IIRBase_ConcurrentStatementList : public IIR_List {

public:
  IIR_Kind get_kind() { return IIR_CONCURRENT_STATEMENT_LIST; }
  IIR_Char *get_kind_text() { return "IIR_ConcurrentStatementList"; }

  IIR_ConcurrentStatement* first();
  IIR_ConcurrentStatement* successor(IIR_ConcurrentStatement*);
  void append_element(IIR_ConcurrentStatement*);

protected:
  IIRBase_ConcurrentStatementList();
  virtual ~IIRBase_ConcurrentStatementList() = 0;
    
private:
};
#endif
