/* Sarien - A Sierra AGI resource interpreter engine
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; see docs/COPYING for further details.
 */

/*
 * Amiga rawkey codes by Paul Hill <paul@lagernet.clara.co.uk>
 */

#ifndef AMIGA_KEYS_H
#define AMIGA_KEYS_H

#define XK_1 1
#define XK_2 2
#define XK_3 3
#define XK_4 4
#define XK_5 5
#define XK_6 6
#define XK_7 7
#define XK_8 8
#define XK_9 9
#define XK_0 10

#define XK_q 16
#define XK_w 17
#define XK_e 18
#define XK_r 19
#define XK_t 20
#define XK_y 21
#define XK_u 22

#define XK_a 32
#define XK_s 33
#define XK_d 34
#define XK_f 35
#define XK_g 36
#define XK_h 37
#define XK_J 38

#define XK_z 49
#define XK_x 50
#define XK_c 51
#define XK_v 52
#define XK_b 53
#define XK_n 54
#define XK_m 55

#define XK_i 23
#define XK_o 24
#define XK_p 25
#define XK_k 39
#define XK_l 40
#define XK_semicolon 41
#define XK_comma 56
#define XK_period 57
#define XK_slash 58

#define XK_Down 77
#define XK_Up 76
#define XK_Left 79
#define XK_Right 78
#define XK_space 64
#define XK_Return 68

#define XK_Tab 66

#define XK_j 38
#define XK_n 54
#define XK_m 55

#define XK_F1 80
#define XK_F2 81
#define XK_F3 82
#define XK_F4 83
#define XK_F5 84
#define XK_F6 85
#define XK_F7 86
#define XK_F8 87
#define XK_F9 88
#define XK_F10 89
#define XK_F11 90
#define XK_F12 91

#define XK_Escape 69
#define XK_equal 12


#define XK_Alt_L 100
#define XK_Alt_R 101
#define XK_Caps_Lock 98
#define XK_Shift_L 96
#define XK_Shift_R 97
#define XK_minus 11

#define XK_BackSpace 65
#define XK_Delete 70
#define XK_Control_L 99

#define XK_Help (0x5F)

#define XK_KP_Home 71
#define XK_KP_Page_Up 72
#define XK_KP_Page_Down 777
#define XK_KP_End 666
#define XK_KP_Enter 555
#define XK_KP_Add 94
#define XK_KP_Subtract 74


#endif /* AMIGA_KEYS_H */




#ifdef gggggg

#define rk_1 1
#define rk_0 10
#define rk_2 2
#define rk_3 3
#define rk_4 4
#define rk_5 5
#define rk_6 6
#define rk_7 7
#define rk_8 8
#define rk_9 9
#define rk_a 0x20
#define rk_b 0x35
#define rk_backslash 13
#define rk_backspace 0x41
#define rk_c 0x33
#define rk_capslock 62
#define rk_closesinglequote 0x2A
#define rk_closesqrbracket 0x1B
#define rk_comma 0x38
#define rk_ctl 0x63
#define rk_d 0x22
#define rk_del 0x46
#define rk_downarrow 0x4D
#define rk_e 0x12
#define rk_equals 12
#define rk_esc 0x45
#define rk_f 0x23
#define rk_F1 0x50
#define rk_F10 0x59
#define rk_F2 0x51
#define rk_F3 0x52
#define rk_F4 0x53
#define rk_F5 0x54
#define rk_F6 0x55
#define rk_F7 0x56
#define rk_F8 0x57
#define rk_F9 0x58
#define rk_fullstop 0x39
#define rk_g 0x24
#define rk_h 0x25
#define rk_help 0x5F
#define rk_i 0x17
#define rk_j 0x26
#define rk_k 0x27
#define rk_kp0 0xF
#define rk_kp1 0x1D
#define rk_kp2 0x1E
#define rk_kp3 0x1F
#define rk_kp4 0x2D
#define rk_kp5 0x2E
#define rk_kp6 0x2F
#define rk_kpdot 0x3C
#define rk_kpenter 0x43
#define rk_kpminus 0x4A
#define rk_l 0x28
#define rk_leftalt 0x64
#define rk_leftamiga 0x66
#define rk_leftarrow 0x4F
#define rk_leftshift 0x60
#define rk_m 0x37
#define rk_minus 11
#define rk_n 0x36
#define rk_o 0x18
#define rk_opensinglequote 0
#define rk_opensqrbracket 0x1A
#define rk_p 0x19
#define rk_q 0x10
#define rk_r 0x13
#define rk_return 0x2B
#define rk_rightalt 0x65
#define rk_rightamiga 0x67
#define rk_rightarrow 0x4E
#define rk_rightshift 0x61
#define rk_s 0x21
#define rk_semicolon 0x29
#define rk_space 0x40
#define rk_t 0x14
#define rk_tab 0x42
#define rk_u 0x16
#define rk_uparrow 0x4C
#define rk_v 0x34
#define rk_w 0x11
#define rk_x 0x32
#define rk_y 0x15
#define rk_z 0x31

#endif
