#!/usr/bin/env python

#############################################################################
##
## This file is part of Taurus, a Tango User Interface Library
## 
## http://www.tango-controls.org/static/taurus/latest/doc/html/index.html
##
## Copyright 2011 CELLS / ALBA Synchrotron, Bellaterra, Spain
## 
## Taurus is free software: you can redistribute it and/or modify
## it under the terms of the GNU Lesser General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
## 
## Taurus is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU Lesser General Public License for more details.
## 
## You should have received a copy of the GNU Lesser General Public License
## along with Taurus.  If not, see <http://www.gnu.org/licenses/>.
##
#############################################################################

"""This module contains some Sardana-wide default configurations.

The idea is that the final user may edit the values here to customize certain
aspects of Sardana.
"""


#:UnitTets door name: is the door to use in our unit tests.
#:Its definition is a mandatory for the unittests. 
#:In case the Door is not valid or defined an exception will be raise.
UNITTEST_DOOR_NAME = "door/demo1/1"

#:Variable controlling the size and number of rotating backups of the log files.
#:The Pool and MacroServer Device servers will use these values for their logs. 
LOG_FILES_SIZE = 1e7
LOG_BCK_COUNT = 5