// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colorscale_h__
#define __colorscale_h__

#include "util.h"

// 0 background (white)
// 1-200 data, 1 lowerlimit 200 upperlimit
// 201 cursor color (white)
// 202-217 colors 
#define IISMAX 200
#define IISCOLORS 201
#define IISSIZE 218

class ColorScale {
public:
  int size_;
  unsigned char* psColors_;  // rgb for ps
  unsigned short* psIndex_;  // index for ps
  unsigned char* colors_;    // for render

public:
  ColorScale(int);
  virtual ~ColorScale();

  int size() {return size_;}
  const unsigned char* psColors() {return psColors_;}
  const unsigned short* psIndex() {return psIndex_;}
  const unsigned char* colors() {return colors_;}
};

class LinearScale : public virtual ColorScale {
public:
  LinearScale(int, unsigned short*, unsigned char*, int);
};

class LogScale : public virtual ColorScale {
public:
  LogScale(int, unsigned short*, unsigned char*, int, double);
};

class PowScale : public virtual ColorScale {
public:
  PowScale(int, unsigned short*, unsigned char*, int, double);
};

class SqrtScale : public virtual ColorScale {
public:
  SqrtScale(int, unsigned short*, unsigned char*, int);
};

class SquaredScale : public virtual ColorScale {
public:
  SquaredScale(int, unsigned short*, unsigned char*, int);
};

class AsinhScale : public virtual ColorScale {
public:
  AsinhScale(int, unsigned short*, unsigned char*, int);
};

class SinhScale : public virtual ColorScale {
public:
  SinhScale(int, unsigned short*, unsigned char*, int);
};

class IISScale : public virtual ColorScale {
public:
  IISScale(unsigned short*, unsigned char*, int);
};

class HistEquScale : public virtual ColorScale {
public:
  HistEquScale(int, unsigned short*, unsigned char*, int, double*, int);
};

#endif
